/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzado;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjd;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzzt;

@zzzt
public final class zzlk {
    private final zzuz zzbdz = new zzuz();
    private final Context mContext;
    private final zzja zzakp;
    private AdListener zzbbk;
    private zzis zzbbj;
    private zzkf zzbee;
    private String zzapb;
    private AppEventListener zzalv;
    private PublisherInterstitialAd zzbej;
    private OnCustomRenderedAdLoadedListener zzbef;
    private Correlator zzbed;
    private RewardedVideoAdListener zzgs;
    private boolean zzbek;
    private boolean zzapq;

    public zzlk(Context context) {
        this(context, zzja.zzbcp, null);
    }

    public zzlk(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzja.zzbcp, publisherInterstitialAd);
    }

    private zzlk(Context context, zzja zzja2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzakp = zzja2;
        this.zzbej = publisherInterstitialAd;
    }

    public final AdListener getAdListener() {
        return this.zzbbk;
    }

    public final String getAdUnitId() {
        return this.zzapb;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzalv;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbef;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbee == null) {
                return false;
            }
            return this.zzbee.isReady();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbee == null) {
                return false;
            }
            return this.zzbee.isLoading();
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public final void zza(zzlg zzlg2) {
        try {
            if (this.zzbee == null) {
                String string = "loadAd";
                zzlk zzlk2 = this;
                if (zzlk2.zzapb == null) {
                    zzlk2.zzaj(string);
                }
                zzjb zzjb2 = zzlk2.zzbek ? zzjb.zzhm() : new zzjb();
                zzuz zzuz2 = zzlk2.zzbdz;
                String string2 = zzlk2.zzapb;
                zzjb zzjb3 = zzjb2;
                Context context = zzlk2.mContext;
                zzjf zzjf2 = zzjo.zzhv();
                zzlk2.zzbee = zzjf.zza(context, false, new zzji(zzjf2, context, zzjb3, string2, zzuz2));
                if (zzlk2.zzbbk != null) {
                    zzlk2.zzbee.zza(new zziu(zzlk2.zzbbk));
                }
                if (zzlk2.zzbbj != null) {
                    zzlk2.zzbee.zza(new zzit(zzlk2.zzbbj));
                }
                if (zzlk2.zzalv != null) {
                    zzlk2.zzbee.zza(new zzjd(zzlk2.zzalv));
                }
                if (zzlk2.zzbef != null) {
                    zzlk2.zzbee.zza(new zznq(zzlk2.zzbef));
                }
                if (zzlk2.zzbed != null) {
                    zzlk2.zzbee.zza(zzlk2.zzbed.zzba());
                }
                if (zzlk2.zzgs != null) {
                    zzlk2.zzbee.zza(new zzado(zzlk2.zzgs));
                }
                zzlk2.zzbee.setImmersiveMode(zzlk2.zzapq);
            }
            if (this.zzbee.zzb(zzja.zza(this.mContext, zzlg2))) {
                this.zzbdz.zzh(zzlg2.zzib());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzbbk = adListener;
            if (this.zzbee != null) {
                this.zzbee.zza(adListener != null ? new zziu(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(zzis zzis2) {
        try {
            this.zzbbj = zzis2;
            if (this.zzbee != null) {
                this.zzbee.zza(zzis2 != null ? new zzit(zzis2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzapb != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzapb = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzalv = appEventListener;
            if (this.zzbee != null) {
                this.zzbee.zza(appEventListener != null ? new zzjd(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzbef = onCustomRenderedAdLoadedListener;
            if (this.zzbee != null) {
                this.zzbee.zza(onCustomRenderedAdLoadedListener != null ? new zznq(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbed = correlator;
        try {
            if (this.zzbee != null) {
                this.zzbee.zza(this.zzbed == null ? null : this.zzbed.zzba());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzgs = rewardedVideoAdListener;
            if (this.zzbee != null) {
                this.zzbee.zza(rewardedVideoAdListener != null ? new zzado(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzbek = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbee != null) {
                return this.zzbee.zzch();
            }
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzaj("show");
            this.zzbee.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to show interstitial.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzapq = bl;
            if (this.zzbee != null) {
                this.zzbee.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaji.zzc("Failed to set immersive mode", remoteException);
            return;
        }
    }

    private final void zzaj(String string) {
        if (this.zzbee == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

