/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzzv;
import java.util.Date;
import java.util.Set;

@zzzv
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzapc {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzgt;
    private InterstitialAd zzgu;
    private AdLoader zzgv;
    private Context zzgw;
    private InterstitialAd zzgx;
    private MediationRewardedVideoAdListener zzgy;
    private RewardedVideoAdListener zzgz = new com.google.ads.mediation.zza(this);

    public AbstractAdViewAdapter() {
    }

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzkb.zzia();
            builder.addTestDevice(zzajr.zzbc(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzgt != null) {
            this.zzgt.destroy();
            this.zzgt = null;
        }
        if (this.zzgu != null) {
            this.zzgu = null;
        }
        if (this.zzgv != null) {
            this.zzgv = null;
        }
        if (this.zzgx != null) {
            this.zzgx = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzgt != null) {
            this.zzgt.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzgt != null) {
            this.zzgt.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgt = new AdView(context);
        this.zzgt.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzgt.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgt.setAdListener(new zzc(this, mediationBannerListener));
        this.zzgt.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzgt;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzgu = new InterstitialAd(context);
        this.zzgu.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgu.setAdListener(new zzd(this, mediationInterstitialListener));
        this.zzgu.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzgu != null) {
            this.zzgu.setImmersiveMode(bl);
        }
        if (this.zzgx != null) {
            this.zzgx.setImmersiveMode(bl);
        }
    }

    @Override
    public zzll getVideoController() {
        VideoController videoController;
        if (this.zzgt != null && (videoController = this.zzgt.getVideoController()) != null) {
            return videoController.zzbj();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzgu.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzah(1).zzuk();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzmo()) {
            for (String string2 : nativeMediationAdRequest.zzmp().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzmp().get(string2) != false ? zze2 : null);
            }
        }
        this.zzgv = builder.build();
        this.zzgv.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzgw = context.getApplicationContext();
        this.zzgy = mediationRewardedVideoAdListener;
        this.zzgy.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzgw == null || this.zzgy == null) {
            zzakb.e("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzgx = new InterstitialAd(this.zzgw);
        this.zzgx.zza(true);
        this.zzgx.setAdUnitId(this.getAdUnitId(bundle));
        this.zzgx.setRewardedVideoAdListener(this.zzgz);
        this.zzgx.loadAd(this.zza(this.zzgw, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzgx.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzgy != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzgy;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzgx = null;
        return null;
    }

    static final class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzhc;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzhc = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzhc);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzamp.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzhc);
            }
        }
    }

    static final class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzhb;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzhb = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzhb);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzamp.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzhb);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener {
        private AbstractAdViewAdapter zzhd;
        private MediationNativeListener zzhg;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhg = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhg.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhg.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhg.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhg.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhg.onAdClicked(this.zzhd);
        }

        @Override
        public final void onAdImpression() {
            this.zzhg.onAdImpression(this.zzhd);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzhg.onAdLoaded(this.zzhd, new zza(nativeAppInstallAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzhg.onAdLoaded(this.zzhd, new zzb(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzhg.zza(this.zzhd, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzhg.zza(this.zzhd, nativeCustomTemplateAd, string);
        }
    }

    static final class zzd
    extends AdListener
    implements zzje {
        private AbstractAdViewAdapter zzhd;
        private MediationInterstitialListener zzhf;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhf = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzhf.onAdLoaded(this.zzhd);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhf.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhf.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhf.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhf.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhf.onAdClicked(this.zzhd);
        }
    }

    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzje {
        private AbstractAdViewAdapter zzhd;
        private MediationBannerListener zzhe;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzhd = abstractAdViewAdapter;
            this.zzhe = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzhe.onAdLoaded(this.zzhd);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzhe.onAdFailedToLoad(this.zzhd, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzhe.onAdOpened(this.zzhd);
        }

        @Override
        public final void onAdClosed() {
            this.zzhe.onAdClosed(this.zzhd);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzhe.onAdLeftApplication(this.zzhd);
        }

        @Override
        public final void onAdClicked() {
            this.zzhe.onAdClicked(this.zzhd);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzhe.zza(this.zzhd, string, string2);
        }
    }
}

