/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.internal.zzuw;

public class AdLoader {
    private final zzjm zzalp;
    private final Context mContext;
    private final zzkk zzalq;

    AdLoader(Context context, zzkk zzkk2) {
        this(context, zzkk2, zzjm.zzbej);
    }

    private AdLoader(Context context, zzkk zzkk2, zzjm zzjm2) {
        this.mContext = context;
        this.zzalq = zzkk2;
        this.zzalp = zzjm2;
    }

    private final void zza(zzlt zzlt2) {
        try {
            this.zzalq.zzd(zzjm.zza(this.mContext, zzlt2));
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzbg());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzlt zzlt2 = adRequest.zzbg();
        AdLoader adLoader = this;
        try {
            adLoader.zzalq.zza(zzjm.zza(adLoader.mContext, zzlt2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzbg());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzalq.zzcp();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzalq.isLoading();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzkn zzalr;

        public Builder(Context context, String string) {
            this((Context)zzbq.checkNotNull((Object)context, (Object)"context cannot be null"), zzkb.zzib().zzb(context, string, new zzuw()));
        }

        private Builder(Context context, zzkn zzkn2) {
            this.mContext = context;
            this.zzalr = zzkn2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzalr.zza(new zzrl(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzalr.zza(new zzrk(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzalr.zza(string, new zzrn(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzrm(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzjn zzjn2 = new zzjn(this.mContext, adSizeArray);
                this.zzalr.zza(new zzro(onPublisherAdViewLoadedListener), zzjn2);
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzalr.zzb(new zzjg(adListener));
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzalr.zza(new zzpe(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzalr.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            zzbq.checkNotNull((Object)correlator);
            try {
                this.zzalr.zzb(correlator.zzbh());
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzalr.zzdi());
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

