/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzlv;

public final class PublisherAdView
extends ViewGroup {
    private final zzlv zzaly;

    public PublisherAdView(Context context) {
        super(context);
        this.zzaly = new zzlv(this);
    }

    public PublisherAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzaly = new zzlv(this, attributeSet, true);
        zzbq.checkNotNull((Object)context, (Object)"Context cannot be null");
    }

    public PublisherAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzaly = new zzlv(this, attributeSet, true);
    }

    public final VideoController getVideoController() {
        return this.zzaly.getVideoController();
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzaly.setVideoOptions(videoOptions);
    }

    public final VideoOptions getVideoOptions() {
        return this.zzaly.getVideoOptions();
    }

    public final void destroy() {
        this.zzaly.destroy();
    }

    public final AdListener getAdListener() {
        return this.zzaly.getAdListener();
    }

    public final AdSize getAdSize() {
        return this.zzaly.getAdSize();
    }

    public final AdSize[] getAdSizes() {
        return this.zzaly.getAdSizes();
    }

    public final String getAdUnitId() {
        return this.zzaly.getAdUnitId();
    }

    public final AppEventListener getAppEventListener() {
        return this.zzaly.getAppEventListener();
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzaly.getOnCustomRenderedAdLoadedListener();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public final void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zzaly.zza(publisherAdRequest.zzbg());
    }

    public final void pause() {
        this.zzaly.pause();
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzaly.setManualImpressionsEnabled(bl);
    }

    public final void recordManualImpression() {
        this.zzaly.recordManualImpression();
    }

    public final void resume() {
        this.zzaly.resume();
    }

    public final void setAdListener(AdListener adListener) {
        this.zzaly.setAdListener(adListener);
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (adSizeArray == null || adSizeArray.length <= 0) {
            throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
        }
        this.zzaly.zza(adSizeArray);
    }

    public final void setAdUnitId(String string) {
        this.zzaly.setAdUnitId(string);
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        this.zzaly.setAppEventListener(appEventListener);
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzaly.setCorrelator(correlator);
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzaly.setOnCustomRenderedAdLoadedListener(onCustomRenderedAdLoadedListener);
    }

    public final String getMediationAdapterClassName() {
        return this.zzaly.getMediationAdapterClassName();
    }

    public final boolean isLoading() {
        return this.zzaly.isLoading();
    }

    public final boolean zza(zzks zzks2) {
        return this.zzaly.zza(zzks2);
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzakb.zzb("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

