/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzpu;

public class NativeAdView
extends FrameLayout {
    private final FrameLayout zzamm;
    private final zzpu zzamn;

    public NativeAdView(Context context) {
        super(context);
        this.zzamm = this.zzb(context);
        this.zzamn = this.zzbm();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzamm = this.zzb(context);
        this.zzamn = this.zzbm();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzamm = this.zzb(context);
        this.zzamn = this.zzbm();
    }

    @TargetApi(value=21)
    public NativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzamm = this.zzb(context);
        this.zzamn = this.zzbm();
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("1098", (View)adChoicesView);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zzq("1098");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    protected final void zza(String string, View view) {
        try {
            this.zzamn.zzb(string, zzn.zzz((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    protected final View zzq(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzamn.zzal(string);
            if (iObjectWrapper != null) {
                return (View)zzn.zzx((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd nativeAd) {
        try {
            this.zzamn.zza((IObjectWrapper)nativeAd.zzbl());
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    public void destroy() {
        try {
            this.zzamn.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzb(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzpu zzbm() {
        zzbq.checkNotNull((Object)this.zzamm, (Object)"createDelegate must be called after mOverlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzkb.zzib().zza(this.zzamm.getContext(), this, this.zzamm);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzamm);
    }

    public void removeView(View view) {
        if (this.zzamm == view) {
            return;
        }
        super.removeView(view);
    }

    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzamm);
    }

    public void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzamm != view) {
            super.bringChildToFront((View)this.zzamm);
        }
    }

    public void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzamn != null) {
            try {
                this.zzamn.zzb(zzn.zzz((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

