/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzpz;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzpz zzamo;
    public static WeakHashMap<View, NativeAdViewHolder> zzamp = new WeakHashMap();
    private WeakReference<View> zzamq;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        zzbq.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView) {
            zzakb.e("The provided containerView is of type NativeAdView. NativeAdView objects should not be used with NativeAdViewHolder.");
            return;
        }
        if (zzamp.get(view) != null) {
            zzakb.e("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzamp.put(view, this);
        this.zzamq = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzd(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzd(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzamo = zzkb.zzib().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzd(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        View view = this.zzamq != null ? (View)this.zzamq.get() : null;
        if (view == null) {
            zzakb.zzcu("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzamp.containsKey(view)) {
            zzamp.put(view, this);
        }
        if (this.zzamo != null) {
            try {
                this.zzamo.zza((IObjectWrapper)nativeAd.zzbl());
                return;
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzamo != null) {
            try {
                this.zzamo.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzakb.zzb("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzamq != null ? (View)this.zzamq.get() : null) != null) {
            zzamp.remove(view);
        }
    }
}

