/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.internal.zzadt;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjx;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpu;
import com.google.android.gms.internal.zzpz;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzux;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzxe;
import com.google.android.gms.internal.zzzv;
import java.util.HashMap;

@zzzv
public class zzjr {
    private zzla zzber;
    private final Object mLock = new Object();
    private final zzji zzbes;
    private final zzjh zzbet;
    private final zzmb zzbeu;
    private final zzri zzbev;
    private final zzadt zzbew;
    private final zzxd zzbex;
    private final zzrj zzbey;

    public zzjr(zzji zzji2, zzjh zzjh2, zzmb zzmb2, zzri zzri2, zzadt zzadt2, zzxd zzxd2, zzrj zzrj2) {
        this.zzbes = zzji2;
        this.zzbet = zzjh2;
        this.zzbeu = zzmb2;
        this.zzbev = zzri2;
        this.zzbew = zzadt2;
        this.zzbex = zzxd2;
        this.zzbey = zzrj2;
    }

    @Nullable
    private static zzla zzhu() {
        try {
            Object obj = zzjr.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzakb.zzcu("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzlb.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzakb.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzla zzhv() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzber == null) {
                this.zzber = zzjr.zzhu();
            }
            return this.zzber;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        boolean bl2 = bl;
        if (!bl2) {
            zzkb.zzia();
            if (!zzajr.zzbe(context)) {
                zzakb.zzbx("Google Play Services is not available");
                bl2 = true;
            }
        }
        zzkb.zzia();
        int n = zzajr.zzaw(context);
        zzkb.zzia();
        if (n > zzajr.zzav(context)) {
            bl2 = true;
        }
        if (bl2) {
            t = zza2.zzhx();
            if (t == null) {
                t = zza2.zzhy();
            }
        } else {
            t = zza2.zzhy();
            if (t == null) {
                t = zza2.zzhx();
            }
        }
        return t;
    }

    private static void zza(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzkb.zzia().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzkn zzb(Context context, String string, zzux zzux2) {
        zzjv zzjv2 = new zzjv(this, context, string, zzux2);
        Context context2 = context;
        return zzjr.zza(context2, false, zzjv2);
    }

    public final zzpu zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        zzjx zzjx2 = new zzjx(this, frameLayout, frameLayout2, context);
        Context context2 = context;
        return zzjr.zza(context2, false, zzjx2);
    }

    public final zzpz zza(View view, HashMap<String, View> hashMap, HashMap<String, View> hashMap2) {
        zzjy zzjy2 = new zzjy(this, view, hashMap, hashMap2);
        Context context = view.getContext();
        return zzjr.zza(context, false, zzjy2);
    }

    @Nullable
    public final zzxe zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzakb.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        return zzjr.zza((Context)activity, bl, new zzka(this, activity));
    }

    static /* synthetic */ zzji zzb(zzjr zzjr2) {
        return zzjr2.zzbes;
    }

    static /* synthetic */ void zza(zzjr zzjr2, Context context, String string) {
        zzjr.zza(context, string);
    }

    static /* synthetic */ zzjh zzc(zzjr zzjr2) {
        return zzjr2.zzbet;
    }

    static /* synthetic */ zzmb zzd(zzjr zzjr2) {
        return zzjr2.zzbeu;
    }

    static /* synthetic */ zzri zze(zzjr zzjr2) {
        return zzjr2.zzbev;
    }

    static /* synthetic */ zzrj zzf(zzjr zzjr2) {
        return zzjr2.zzbey;
    }

    static /* synthetic */ zzadt zzg(zzjr zzjr2) {
        return zzjr2.zzbew;
    }

    static /* synthetic */ zzxd zzh(zzjr zzjr2) {
        return zzjr2.zzbex;
    }

    @VisibleForTesting
    abstract class zza<T> {
        private /* synthetic */ zzjr zzbfc;

        zza(zzjr zzjr2) {
            this.zzbfc = zzjr2;
        }

        @Nullable
        protected abstract T zza(zzla var1) throws RemoteException;

        @Nullable
        protected abstract T zzhw() throws RemoteException;

        @Nullable
        protected final T zzhx() {
            zzla zzla2 = this.zzbfc.zzhv();
            if (zzla2 == null) {
                zzakb.zzcu("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzla2);
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzhy() {
            try {
                return this.zzhw();
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

