/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjq;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzjt;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzzv;
import java.util.concurrent.atomic.AtomicBoolean;

@zzzv
public final class zzlv {
    private final zzuw zzbgb = new zzuw();
    private final zzjm zzalp;
    private final AtomicBoolean zzbgc;
    private final VideoController zzbgd = new VideoController();
    private zzkd zzbge = new zzlw(this);
    private zzje zzbdd;
    private AdListener zzbde;
    private AdSize[] zzbeq;
    private AppEventListener zzamt;
    private Correlator zzbgf;
    private zzks zzbgg;
    private OnCustomRenderedAdLoadedListener zzbgh;
    private VideoOptions zzaml;
    private String zzapq;
    private ViewGroup zzbgi;
    private int zzbgj;
    private boolean zzamr;

    public zzlv(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzjm.zzbej, 0);
    }

    public zzlv(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzjm.zzbej, n);
    }

    public zzlv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzjm.zzbej, 0);
    }

    public zzlv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzjm.zzbej, n);
    }

    private zzlv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjm zzjm2, zzks zzks2, int n) {
        this.zzbgi = viewGroup;
        this.zzalp = zzjm2;
        this.zzbgg = null;
        this.zzbgc = new AtomicBoolean(false);
        this.zzbgj = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzjq zzjq2 = new zzjq(context, attributeSet);
                this.zzbeq = zzjq2.zzh(bl);
                this.zzapq = zzjq2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkb.zzia().zza(viewGroup, new zzjn(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzbgj;
                AdSize adSize = this.zzbeq[0];
                Context context2 = context;
                zzjn zzjn2 = new zzjn(context2, adSize);
                new zzjn(context2, adSize).zzbep = bl2 = zzlv.zzs(n2);
                zzkb.zzia().zza(viewGroup, zzjn2, "Ads by Google");
            }
        }
    }

    private zzlv(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjm zzjm2, int n) {
        this(viewGroup, attributeSet, bl, zzjm2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbgg != null) {
                this.zzbgg.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzbde;
    }

    public final AdSize getAdSize() {
        try {
            zzjn zzjn2;
            if (this.zzbgg != null && (zzjn2 = this.zzbgg.zzbs()) != null) {
                return zzjn2.zzht();
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzbeq != null) {
            return this.zzbeq[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzbeq;
    }

    public final String getAdUnitId() {
        if (this.zzapq == null && this.zzbgg != null) {
            try {
                this.zzapq = this.zzbgg.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzakb.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zzapq;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzamt;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbgh;
    }

    public final void zza(zzlt zzlt2) {
        try {
            if (this.zzbgg == null) {
                zzks zzks2;
                zzjn zzjn2;
                zzlv zzlv2 = this;
                if ((zzlv2.zzbeq == null || zzlv2.zzapq == null) && zzlv2.zzbgg == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzlv zzlv3 = zzlv2;
                Context context = zzlv3.zzbgi.getContext();
                Object object = zzjn2 = zzlv.zza(context, zzlv3.zzbeq, zzlv3.zzbgj);
                if ("search_v2".equals(object.zzbek)) {
                    String string = zzlv3.zzapq;
                    zzjn zzjn3 = zzjn2;
                    Context context2 = context;
                    object = zzkb.zzib();
                    zzjt zzjt2 = new zzjt((zzjr)object, context2, zzjn3, string);
                    Context context3 = context2;
                    zzks2 = zzjr.zza(context3, false, zzjt2);
                } else {
                    zzuw zzuw2 = zzlv3.zzbgb;
                    String string = zzlv3.zzapq;
                    zzjn zzjn4 = zzjn2;
                    Context context4 = context;
                    object = zzkb.zzib();
                    zzjs zzjs2 = new zzjs((zzjr)object, context4, zzjn4, string, zzuw2);
                    Context context5 = context4;
                    zzks2 = zzjr.zza(context5, false, zzjs2);
                }
                zzlv2.zzbgg = zzks2;
                zzlv2.zzbgg.zza(new zzjg(zzlv2.zzbge));
                if (zzlv2.zzbdd != null) {
                    zzlv2.zzbgg.zza(new zzjf(zzlv2.zzbdd));
                }
                if (zzlv2.zzamt != null) {
                    zzlv2.zzbgg.zza(new zzjp(zzlv2.zzamt));
                }
                if (zzlv2.zzbgh != null) {
                    zzlv2.zzbgg.zza(new zzod(zzlv2.zzbgh));
                }
                if (zzlv2.zzbgf != null) {
                    zzlv2.zzbgg.zza(zzlv2.zzbgf.zzbh());
                }
                if (zzlv2.zzaml != null) {
                    zzlv2.zzbgg.zza(new zzmr(zzlv2.zzaml));
                }
                zzlv2.zzbgg.setManualImpressionsEnabled(zzlv2.zzamr);
                zzlv zzlv4 = zzlv2;
                try {
                    IObjectWrapper iObjectWrapper = zzlv4.zzbgg.zzbr();
                    if (iObjectWrapper != null) {
                        zzlv4.zzbgi.addView((View)zzn.zzx((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzakb.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzbgg.zzb(zzjm.zza(this.zzbgi.getContext(), zzlt2))) {
                this.zzbgb.zzn(zzlt2.zzim());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbgg != null) {
                this.zzbgg.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzbgc.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zzbu();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbgg != null) {
                this.zzbgg.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzbde = adListener;
        this.zzbge.zza(adListener);
    }

    public final void zza(zzje zzje2) {
        try {
            this.zzbdd = zzje2;
            if (this.zzbgg != null) {
                this.zzbgg.zza(zzje2 != null ? new zzjf(zzje2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzbeq != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzbeq = adSizeArray;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zza(zzlv.zza(this.zzbgi.getContext(), this.zzbeq, this.zzbgj));
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzbgi.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzapq != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzapq = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzamt = appEventListener;
            if (this.zzbgg != null) {
                this.zzbgg.zza(appEventListener != null ? new zzjp(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzbgh = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zza(onCustomRenderedAdLoadedListener != null ? new zzod(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzamr = bl;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.setManualImpressionsEnabled(this.zzamr);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbgf = correlator;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zza(this.zzbgf == null ? null : this.zzbgf.zzbh());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbgg != null) {
                return this.zzbgg.zzcp();
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbgg != null) {
                return this.zzbgg.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzbgd;
    }

    public final zzll zzbj() {
        if (this.zzbgg == null) {
            return null;
        }
        try {
            return this.zzbgg.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzaml = videoOptions;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zza(videoOptions == null ? null : new zzmr(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzaml;
    }

    public final boolean zza(zzks zzks2) {
        IObjectWrapper iObjectWrapper;
        if (zzks2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzks2.zzbr();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)zzn.zzx((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzbgi.addView((View)zzn.zzx((IObjectWrapper)iObjectWrapper));
        this.zzbgg = zzks2;
        return true;
    }

    private static zzjn zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzjn zzjn2 = new zzjn(context, adSizeArray);
        new zzjn(context, adSizeArray).zzbep = bl = zzlv.zzs(n);
        return zzjn2;
    }

    private static boolean zzs(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzlv zzlv2) {
        return zzlv2.zzbgd;
    }
}

