/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.internal.zzadu;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzjg;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzzv;

@zzzv
public final class zzlx {
    private final zzuw zzbgb = new zzuw();
    private final Context mContext;
    private final zzjm zzalp;
    private AdListener zzbde;
    private zzje zzbdd;
    private zzks zzbgg;
    private String zzapq;
    private AppEventListener zzamt;
    private PublisherInterstitialAd zzbgl;
    private OnCustomRenderedAdLoadedListener zzbgh;
    private Correlator zzbgf;
    private RewardedVideoAdListener zzgz;
    private boolean zzbgm;
    private boolean zzaqg;

    public zzlx(Context context) {
        this(context, zzjm.zzbej, null);
    }

    public zzlx(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzjm.zzbej, publisherInterstitialAd);
    }

    private zzlx(Context context, zzjm zzjm2, PublisherInterstitialAd publisherInterstitialAd) {
        this.mContext = context;
        this.zzalp = zzjm2;
        this.zzbgl = publisherInterstitialAd;
    }

    public final AdListener getAdListener() {
        return this.zzbde;
    }

    public final String getAdUnitId() {
        return this.zzapq;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzamt;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzbgh;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbgg == null) {
                return false;
            }
            return this.zzbgg.isReady();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to check if ad is ready.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbgg == null) {
                return false;
            }
            return this.zzbgg.isLoading();
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public final void zza(zzlt zzlt2) {
        try {
            if (this.zzbgg == null) {
                String string = "loadAd";
                zzlx zzlx2 = this;
                if (zzlx2.zzapq == null) {
                    zzlx2.zzak(string);
                }
                zzjn zzjn2 = zzlx2.zzbgm ? zzjn.zzhs() : new zzjn();
                zzuw zzuw2 = zzlx2.zzbgb;
                String string2 = zzlx2.zzapq;
                zzjn zzjn3 = zzjn2;
                Context context = zzlx2.mContext;
                zzjr zzjr2 = zzkb.zzib();
                zzju zzju2 = new zzju(zzjr2, context, zzjn3, string2, zzuw2);
                Context context2 = context;
                zzlx2.zzbgg = zzjr.zza(context2, false, zzju2);
                if (zzlx2.zzbde != null) {
                    zzlx2.zzbgg.zza(new zzjg(zzlx2.zzbde));
                }
                if (zzlx2.zzbdd != null) {
                    zzlx2.zzbgg.zza(new zzjf(zzlx2.zzbdd));
                }
                if (zzlx2.zzamt != null) {
                    zzlx2.zzbgg.zza(new zzjp(zzlx2.zzamt));
                }
                if (zzlx2.zzbgh != null) {
                    zzlx2.zzbgg.zza(new zzod(zzlx2.zzbgh));
                }
                if (zzlx2.zzbgf != null) {
                    zzlx2.zzbgg.zza(zzlx2.zzbgf.zzbh());
                }
                if (zzlx2.zzgz != null) {
                    zzlx2.zzbgg.zza(new zzadu(zzlx2.zzgz));
                }
                zzlx2.zzbgg.setImmersiveMode(zzlx2.zzaqg);
            }
            if (this.zzbgg.zzb(zzjm.zza(this.mContext, zzlt2))) {
                this.zzbgb.zzn(zzlt2.zzim());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzbde = adListener;
            if (this.zzbgg != null) {
                this.zzbgg.zza(adListener != null ? new zzjg(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(zzje zzje2) {
        try {
            this.zzbdd = zzje2;
            if (this.zzbgg != null) {
                this.zzbgg.zza(zzje2 != null ? new zzjf(zzje2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzapq != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzapq = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzamt = appEventListener;
            if (this.zzbgg != null) {
                this.zzbgg.zza(appEventListener != null ? new zzjp(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzbgh = onCustomRenderedAdLoadedListener;
            if (this.zzbgg != null) {
                this.zzbgg.zza(onCustomRenderedAdLoadedListener != null ? new zzod(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the OnCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzbgf = correlator;
        try {
            if (this.zzbgg != null) {
                this.zzbgg.zza(this.zzbgf == null ? null : this.zzbgf.zzbh());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzgz = rewardedVideoAdListener;
            if (this.zzbgg != null) {
                this.zzbgg.zza(rewardedVideoAdListener != null ? new zzadu(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set the AdListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzbgm = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbgg != null) {
                return this.zzbgg.zzcp();
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzak("show");
            this.zzbgg.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to show interstitial.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzaqg = bl;
            if (this.zzbgg != null) {
                this.zzbgg.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc("Failed to set immersive mode", remoteException);
            return;
        }
    }

    private final void zzak(String string) {
        if (this.zzbgg == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

