/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzzv;
import java.util.List;
import java.util.WeakHashMap;

@zzzv
public final class zzqp
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzqp> zzbwk = new WeakHashMap();
    private final zzqm zzbwl;
    private final MediaView zzbwm;
    private final VideoController zzbgd = new VideoController();

    private zzqp(zzqm zzqm2) {
        this.zzbwl = zzqm2;
        Context context = null;
        try {
            context = (Context)zzn.zzx((IObjectWrapper)zzqm2.zzka());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzakb.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzbwl.zzf(zzn.zzz((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzakb.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzbwm = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzqp zza(zzqm zzqm2) {
        WeakHashMap<IBinder, zzqp> weakHashMap = zzbwk;
        synchronized (weakHashMap) {
            zzqp zzqp2 = zzbwk.get(zzqm2.asBinder());
            if (zzqp2 != null) {
                return zzqp2;
            }
            zzqp2 = new zzqp(zzqm2);
            zzbwk.put(zzqm2.asBinder(), zzqp2);
            return zzqp2;
        }
    }

    public final zzqm zzkm() {
        return this.zzbwl;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzbwl.zzap(string);
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzpq zzpq2 = this.zzbwl.zzaq(string);
            if (zzpq2 != null) {
                return new zzpt(zzpq2);
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzll zzll2 = this.zzbwl.getVideoController();
            if (zzll2 != null) {
                this.zzbgd.zza(zzll2);
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzbgd;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzbwm;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzbwl.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzbwl.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzbwl.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzbwl.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzbwl.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

