/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;

public final class AdSize {
    public static final int FULL_WIDTH = -1;
    public static final int AUTO_HEIGHT = -2;
    public static final AdSize BANNER = new AdSize(320, 50, "320x50_mb");
    public static final AdSize FULL_BANNER = new AdSize(468, 60, "468x60_as");
    public static final AdSize LARGE_BANNER = new AdSize(320, 100, "320x100_as");
    public static final AdSize LEADERBOARD = new AdSize(728, 90, "728x90_as");
    public static final AdSize MEDIUM_RECTANGLE = new AdSize(300, 250, "300x250_as");
    public static final AdSize WIDE_SKYSCRAPER = new AdSize(160, 600, "160x600_as");
    public static final AdSize SMART_BANNER = new AdSize(-1, -2, "smart_banner");
    public static final AdSize FLUID = new AdSize(-3, -4, "fluid");
    @Hide
    public static final AdSize zza = new AdSize(50, 50, "50x50_mb");
    public static final AdSize SEARCH = new AdSize(-3, 0, "search_v2");
    private final int zzb;
    private final int zzc;
    private final String zzd;

    public AdSize(int n, int n2) {
        String string = n == -1 ? "FULL" : String.valueOf(n);
        String string2 = n2 == -2 ? "AUTO" : String.valueOf(n2);
        this(n, n2, new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("x").append(string2).append("_as").toString());
    }

    @Hide
    AdSize(int n, int n2, String string) {
        if (n < 0 && n != -1 && n != -3) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Invalid width for AdSize: ").append(n).toString());
        }
        if (n2 < 0 && n2 != -2 && n2 != -4) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Invalid height for AdSize: ").append(n2).toString());
        }
        this.zzb = n;
        this.zzc = n2;
        this.zzd = string;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AdSize)) {
            return false;
        }
        AdSize adSize = (AdSize)object;
        return this.zzb == adSize.zzb && this.zzc == adSize.zzc && this.zzd.equals(adSize.zzd);
    }

    public final int getHeight() {
        return this.zzc;
    }

    public final int getHeightInPixels(Context context) {
        switch (this.zzc) {
            case -2: {
                return zzko.zzb(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        zzlc.zza();
        return zzako.zza(context, this.zzc);
    }

    public final int getWidth() {
        return this.zzb;
    }

    public final int getWidthInPixels(Context context) {
        switch (this.zzb) {
            case -1: {
                return zzko.zza(context.getResources().getDisplayMetrics());
            }
            case -4: 
            case -3: {
                return -1;
            }
        }
        zzlc.zza();
        return zzako.zza(context, this.zzb);
    }

    public final int hashCode() {
        return this.zzd.hashCode();
    }

    public final boolean isAutoHeight() {
        return this.zzc == -2;
    }

    public final boolean isFullWidth() {
        return this.zzb == -1;
    }

    public final boolean isFluid() {
        return this.zzb == -3 && this.zzc == -4;
    }

    public final String toString() {
        return this.zzd;
    }
}

