/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.zzf;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzakr;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.UUID;

@zzabh
@Hide
public final class zzako {
    public static final Handler zza = new Handler(Looper.getMainLooper());
    private static final String zzb = AdView.class.getName();
    private static final String zzc = InterstitialAd.class.getName();
    private static final String zzd = PublisherAdView.class.getName();
    private static final String zze = PublisherInterstitialAd.class.getName();
    private static final String zzf = SearchAdView.class.getName();
    private static final String zzg = AdLoader.class.getName();

    public static void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static int zza(Context context, int n) {
        return zzako.zza(context.getResources().getDisplayMetrics(), n);
    }

    public static int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public static int zzb(Context context, int n) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return zzako.zzb(displayMetrics, n);
    }

    public static int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public final void zza(ViewGroup viewGroup, zzko zzko2, String string, String string2) {
        zzaky.zze(string2);
        this.zza(viewGroup, zzko2, string, -65536, -16777216);
    }

    public final void zza(ViewGroup viewGroup, zzko zzko2, String string) {
        this.zza(viewGroup, zzko2, string, -16777216, -1);
    }

    private final void zza(ViewGroup viewGroup, zzko zzko2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzako.zza(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zzko2.zzf - n3, zzko2.zzc - n3, 17));
        viewGroup.addView((View)frameLayout, zzko2.zzf, zzko2.zzc);
    }

    public static String zza(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return zzako.zza(string == null || zzako.zza() ? "emulator" : string);
    }

    @Nullable
    public static String zzb(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static boolean zza() {
        return Build.DEVICE.startsWith("generic");
    }

    public static boolean zzb() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String zza(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        return null;
    }

    public static boolean zzc(Context context) {
        return 0 == com.google.android.gms.common.zzf.zza().isGooglePlayServicesAvailable(context);
    }

    public static int zzd(Context context) {
        return DynamiteModule.zzb((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zze(Context context) {
        return DynamiteModule.zza((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static boolean zzf(Context context) {
        int n = com.google.android.gms.common.zzf.zza().isGooglePlayServicesAvailable(context);
        return n == 0 || n == 2;
    }

    public static boolean zzg(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public static boolean zzh(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (zzs.zzc()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public static int zzi(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    public static String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzb.equalsIgnoreCase(string3) || zzc.equalsIgnoreCase(string3) || zzd.equalsIgnoreCase(string3) || zze.equalsIgnoreCase(string3) || zzf.equalsIgnoreCase(string3) || zzg.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5;
            String string6;
            int n2 = 3;
            String string7 = ".";
            String string8 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string8, string7);
            StringBuilder stringBuilder = new StringBuilder();
            --n2;
            if (!stringTokenizer.hasMoreElements()) {
                string6 = string8;
            } else {
                stringBuilder.append(stringTokenizer.nextToken());
                while (n2-- > 0 && stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(".").append(stringTokenizer.nextToken());
                }
                string6 = string5 = stringBuilder.toString();
            }
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        zzako.zza(context, null, string2, bundle, true, new zzakp(this));
    }

    public static void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zzakr zzakr2) {
        Context context2;
        if (bl) {
            context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            bundle.putString("os", Build.VERSION.RELEASE);
            bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
            bundle.putString("appid", context2.getPackageName());
            if (string == null) {
                com.google.android.gms.common.zzf.zza();
                int n = com.google.android.gms.common.zzf.zzd((Context)context);
                string = new StringBuilder(20).append(n).append(".12210000").toString();
            }
            bundle.putString("js", string);
        }
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzakr2.zza(context2.toString());
    }

    public static String zzc() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string;
    }

    public static Throwable zza(Throwable throwable) {
        Throwable throwable2;
        Object object = zzoi.zzc;
        if (zzlc.zzf().zza(object).booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                if (zzako.zzb(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                object = stackTraceElement.getClassName();
                if (!TextUtils.isEmpty((CharSequence)object) && (((String)object).startsWith("android.") || ((String)object).startsWith("java."))) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }

    public static boolean zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzny<String> zzny2 = zzoi.zzd;
        if (string.startsWith(zzlc.zzf().zza(zzny2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzabh.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzaky.zza(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class "), exception);
            return false;
        }
    }
}

