/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import android.util.JsonWriter;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzaku;
import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzoi;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@zzabh
@Hide
public final class zzaks {
    private static Object zza = new Object();
    @GuardedBy(value="sLock")
    private static boolean zzb = false;
    @GuardedBy(value="sLock")
    private static boolean zzc = false;
    private static zze zzd = zzi.zzd();
    private static final Set<String> zze = new HashSet<String>(Arrays.asList(new String[0]));
    private final List<String> zzf;

    public zzaks() {
        this(null);
    }

    public zzaks(@Nullable String string) {
        List<String> list;
        String string2 = string;
        if (!zzaks.zzc()) {
            list = new ArrayList<String>();
        } else {
            String string3 = UUID.randomUUID().toString();
            if (string2 == null) {
                String[] stringArray = new String[1];
                String string4 = String.valueOf(string3);
                stringArray[0] = string4.length() != 0 ? "network_request_".concat(string4) : new String("network_request_");
                list = Arrays.asList(stringArray);
            } else {
                String[] stringArray = new String[2];
                String string5 = String.valueOf(string2);
                stringArray[0] = string5.length() != 0 ? "ad_request_".concat(string5) : new String("ad_request_");
                String string6 = String.valueOf(string3);
                stringArray[1] = string6.length() != 0 ? "network_request_".concat(string6) : new String("network_request_");
                list = Arrays.asList(stringArray);
            }
        }
        this.zzf = list;
    }

    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzaks.zzc()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzb(string, string2, hashMap, byArray);
    }

    public final void zza(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzaks.zzc()) {
            return;
        }
        this.zzb(string, string2, map, byArray);
    }

    private final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        this.zza("onNetworkRequest", new zzakt(string, string2, map, byArray));
    }

    public final void zza(HttpURLConnection httpURLConnection, int n) {
        if (!zzaks.zzc()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getHeaderFields() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getHeaderFields());
        this.zzb(hashMap, n);
        if (n < 200 || n >= 300) {
            String string = null;
            try {
                string = httpURLConnection.getResponseMessage();
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException.getMessage());
                zzaky.zze(string2.length() != 0 ? "Can not get error message from error HttpURLConnection\n".concat(string2) : new String("Can not get error message from error HttpURLConnection\n"));
            }
            this.zzb(string);
        }
    }

    public final void zza(@Nullable Map<String, ?> map, int n) {
        if (!zzaks.zzc()) {
            return;
        }
        this.zzb(map, n);
        if (n < 200 || n >= 300) {
            this.zzb(null);
        }
    }

    private final void zzb(@Nullable Map<String, ?> map, int n) {
        this.zza("onNetworkResponse", new zzaku(n, map));
    }

    public final void zza(@Nullable String string) {
        if (!zzaks.zzc()) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.zza(byArray);
    }

    public final void zza(byte[] byArray) {
        this.zza("onNetworkResponseBody", new zzakv(byArray));
    }

    private final void zzb(@Nullable String string) {
        this.zza("onNetworkRequestError", new zzakw(string));
    }

    private static void zza(JsonWriter jsonWriter, @Nullable Map<String, ?> map) throws IOException {
        if (map == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (zze.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (String string2 : (List)entry.getValue()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(string2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzaky.zzc("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    private final void zza(String string, zzakx zzakx2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zzd.zza());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            for (String string2 : this.zzf) {
                jsonWriter.value(string2);
            }
            jsonWriter.endArray();
            zzakx2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzaky.zzb("unable to log", iOException);
        }
        zzaks.zzc(stringWriter.toString());
    }

    private static synchronized void zzc(String string) {
        zzaky.zzd("GMA Debug BEGIN");
        for (int i = 0; i < string.length(); i += 4000) {
            int n = Math.min(i + 4000, string.length());
            String string2 = String.valueOf(string.substring(i, n));
            zzaky.zzd(string2.length() != 0 ? "GMA Debug CONTENT ".concat(string2) : new String("GMA Debug CONTENT "));
        }
        zzaky.zzd("GMA Debug FINISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zza() {
        Object object = zza;
        synchronized (object) {
            zzb = false;
            zzc = false;
            zzaky.zze("Ad debug logging enablement is out of date.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zza(boolean bl) {
        Object object = zza;
        synchronized (object) {
            zzb = true;
            zzc = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzb() {
        Object object = zza;
        synchronized (object) {
            return zzb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzc() {
        Object object = zza;
        synchronized (object) {
            return zzb && zzc;
        }
    }

    public static boolean zza(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        zzny<Boolean> zzny2 = zzoi.zzcz;
        return zzlc.zzf().zza(zzny2) != false && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
    }

    static final /* synthetic */ void zza(String string, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        if (string != null) {
            jsonWriter.name("error_description").value(string);
        }
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        int n = byArray.length;
        String string = com.google.android.gms.common.util.zzc.zza((byte[])byArray);
        if (n < 10000) {
            jsonWriter.name("body").value(string);
        } else {
            String string2 = zzako.zza(string);
            if (string2 != null) {
                jsonWriter.name("bodydigest").value(string2);
            }
        }
        jsonWriter.name("bodylength").value((long)n);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzaks.zza(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzaks.zza(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(com.google.android.gms.common.util.zzc.zza((byte[])byArray));
        }
        jsonWriter.endObject();
    }
}

