/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzlc;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzlt;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzwe;
import java.util.concurrent.atomic.AtomicBoolean;

@zzabh
@Hide
public final class zzmw {
    private final zzwe zza = new zzwe();
    private final zzkn zzb;
    private final AtomicBoolean zzc;
    private final VideoController zzd = new VideoController();
    private zzle zze = new zzmx(this);
    private zzkf zzf;
    private AdListener zzg;
    private AdSize[] zzh;
    private AppEventListener zzi;
    private Correlator zzj;
    private zzlt zzk;
    private OnCustomRenderedAdLoadedListener zzl;
    private VideoOptions zzm;
    private String zzn;
    private ViewGroup zzo;
    private int zzp;
    private boolean zzq;

    public zzmw(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzkn.zza, 0);
    }

    public zzmw(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzkn.zza, n);
    }

    public zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzkn.zza, 0);
    }

    public zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzkn.zza, n);
    }

    private zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzkn zzkn2, zzlt zzlt2, int n) {
        this.zzo = viewGroup;
        this.zzb = zzkn2;
        this.zzk = null;
        this.zzc = new AtomicBoolean(false);
        this.zzp = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzkr zzkr2 = new zzkr(context, attributeSet);
                this.zzh = zzkr2.zza(bl);
                this.zzn = zzkr2.zza();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzlc.zza().zza(viewGroup, new zzko(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzp;
                AdSize adSize = this.zzh[0];
                Context context2 = context;
                zzko zzko2 = new zzko(context2, adSize);
                new zzko(context2, adSize).zzj = bl2 = zzmw.zza(n2);
                zzlc.zza().zza(viewGroup, zzko2, "Ads by Google");
            }
        }
    }

    private zzmw(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzkn zzkn2, int n) {
        this(viewGroup, attributeSet, bl, zzkn2, null, n);
    }

    public final void zza() {
        try {
            if (this.zzk != null) {
                this.zzk.zzb();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to destroy AdView.", remoteException);
            return;
        }
    }

    public final AdListener zzb() {
        return this.zzg;
    }

    public final AdSize zzc() {
        try {
            zzko zzko2;
            if (this.zzk != null && (zzko2 = this.zzk.zzd()) != null) {
                return zzko2.zzb();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the current AdSize.", remoteException);
        }
        if (this.zzh != null) {
            return this.zzh[0];
        }
        return null;
    }

    public final AdSize[] zzd() {
        return this.zzh;
    }

    public final String zze() {
        if (this.zzn == null && this.zzk != null) {
            try {
                this.zzn = this.zzk.zzv();
            }
            catch (RemoteException remoteException) {
                zzaky.zzc("Failed to get ad unit id.", remoteException);
            }
        }
        return this.zzn;
    }

    public final AppEventListener zzf() {
        return this.zzi;
    }

    public final OnCustomRenderedAdLoadedListener zzg() {
        return this.zzl;
    }

    public final void zza(zzmu zzmu2) {
        try {
            if (this.zzk == null) {
                zzlt zzlt2;
                zzko zzko2;
                zzmw zzmw2 = this;
                if ((zzmw2.zzh == null || zzmw2.zzn == null) && zzmw2.zzk == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzmw zzmw3 = zzmw2;
                Context context = zzmw3.zzo.getContext();
                Object object = zzko2 = zzmw.zza(context, zzmw3.zzh, zzmw3.zzp);
                if ("search_v2".equals(object.zza)) {
                    String string = zzmw3.zzn;
                    zzko zzko3 = zzko2;
                    Context context2 = context;
                    object = zzlc.zzb();
                    zzku zzku2 = new zzku((zzks)object, context2, zzko3, string);
                    Context context3 = context2;
                    zzlt2 = zzks.zza(context3, false, zzku2);
                } else {
                    zzwe zzwe2 = zzmw3.zza;
                    String string = zzmw3.zzn;
                    zzko zzko4 = zzko2;
                    Context context4 = context;
                    object = zzlc.zzb();
                    zzkt zzkt2 = new zzkt((zzks)object, context4, zzko4, string, zzwe2);
                    Context context5 = context4;
                    zzlt2 = zzks.zza(context5, false, zzkt2);
                }
                zzmw2.zzk = zzlt2;
                zzmw2.zzk.zza(new zzkh(zzmw2.zze));
                if (zzmw2.zzf != null) {
                    zzmw2.zzk.zza(new zzkg(zzmw2.zzf));
                }
                if (zzmw2.zzi != null) {
                    zzmw2.zzk.zza(new zzkq(zzmw2.zzi));
                }
                if (zzmw2.zzl != null) {
                    zzmw2.zzk.zza(new zzpe(zzmw2.zzl));
                }
                if (zzmw2.zzj != null) {
                    zzmw2.zzk.zza(zzmw2.zzj.zza());
                }
                if (zzmw2.zzm != null) {
                    zzmw2.zzk.zza(new zzns(zzmw2.zzm));
                }
                zzmw2.zzk.zza(zzmw2.zzq);
                zzmw zzmw4 = zzmw2;
                try {
                    IObjectWrapper iObjectWrapper = zzmw4.zzk.zzc();
                    if (iObjectWrapper != null) {
                        zzmw4.zzo.addView((View)com.google.android.gms.dynamic.zzn.zza((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzaky.zzc("Failed to get an ad frame.", remoteException);
                }
            }
            if (this.zzk.zzb(zzkn.zza(this.zzo.getContext(), zzmu2))) {
                this.zza.zza(zzmu2.zzj());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    public final void zzh() {
        try {
            if (this.zzk != null) {
                this.zzk.zzh();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to call pause.", remoteException);
            return;
        }
    }

    public final void zzi() {
        if (this.zzc.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzk != null) {
                this.zzk.zzg();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to record impression.", remoteException);
            return;
        }
    }

    public final void zzj() {
        try {
            if (this.zzk != null) {
                this.zzk.zzi();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to call resume.", remoteException);
            return;
        }
    }

    public final void zza(AdListener adListener) {
        this.zzg = adListener;
        this.zze.zza(adListener);
    }

    public final void zza(zzkf zzkf2) {
        try {
            this.zzf = zzkf2;
            if (this.zzk != null) {
                this.zzk.zza(zzkf2 != null ? new zzkg(zzkf2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AdClickListener.", remoteException);
            return;
        }
    }

    public final void zza(AdSize ... adSizeArray) {
        if (this.zzh != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zzb(adSizeArray);
    }

    public final void zzb(AdSize ... adSizeArray) {
        this.zzh = adSizeArray;
        try {
            if (this.zzk != null) {
                this.zzk.zza(zzmw.zza(this.zzo.getContext(), this.zzh, this.zzp));
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the ad size.", remoteException);
        }
        this.zzo.requestLayout();
    }

    public final void zza(String string) {
        if (this.zzn != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzn = string;
    }

    public final void zza(AppEventListener appEventListener) {
        try {
            this.zzi = appEventListener;
            if (this.zzk != null) {
                this.zzk.zza(appEventListener != null ? new zzkq(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the AppEventListener.", remoteException);
            return;
        }
    }

    public final void zza(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzl = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzk != null) {
                this.zzk.zza(onCustomRenderedAdLoadedListener != null ? new zzpe(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set the onCustomRenderedAdLoadedListener.", remoteException);
            return;
        }
    }

    public final void zza(boolean bl) {
        this.zzq = bl;
        try {
            if (this.zzk != null) {
                this.zzk.zza(this.zzq);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set manual impressions.", remoteException);
            return;
        }
    }

    public final void zza(Correlator correlator) {
        this.zzj = correlator;
        try {
            if (this.zzk != null) {
                this.zzk.zza(this.zzj == null ? null : this.zzj.zza());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set correlator.", remoteException);
            return;
        }
    }

    public final String zzk() {
        try {
            if (this.zzk != null) {
                return this.zzk.zzam();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get the mediation adapter class name.", remoteException);
        }
        return null;
    }

    public final boolean zzl() {
        try {
            if (this.zzk != null) {
                return this.zzk.zzk();
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to check if ad is loading.", remoteException);
        }
        return false;
    }

    public final VideoController zzm() {
        return this.zzd;
    }

    public final zzmm zzn() {
        if (this.zzk == null) {
            return null;
        }
        try {
            return this.zzk.zzl();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to retrieve VideoController.", remoteException);
            return null;
        }
    }

    public final void zza(VideoOptions videoOptions) {
        this.zzm = videoOptions;
        try {
            if (this.zzk != null) {
                this.zzk.zza(videoOptions == null ? null : new zzns(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to set video options.", remoteException);
            return;
        }
    }

    public final VideoOptions zzo() {
        return this.zzm;
    }

    public final boolean zza(zzlt zzlt2) {
        IObjectWrapper iObjectWrapper;
        if (zzlt2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzlt2.zzc();
        }
        catch (RemoteException remoteException) {
            zzaky.zzc("Failed to get an ad frame.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)com.google.android.gms.dynamic.zzn.zza((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzo.addView((View)com.google.android.gms.dynamic.zzn.zza((IObjectWrapper)iObjectWrapper));
        this.zzk = zzlt2;
        return true;
    }

    private static zzko zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzko zzko2 = new zzko(context, adSizeArray);
        new zzko(context, adSizeArray).zzj = bl = zzmw.zza(n);
        return zzko2;
    }

    private static boolean zza(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzmw zzmw2) {
        return zzmw2.zzd;
    }
}

