/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzqs;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzro;
import java.util.List;
import java.util.WeakHashMap;

@zzabh
@Hide
public final class zzrr
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzrr> zza = new WeakHashMap();
    private final zzro zzb;
    private final MediaView zzc;
    private final VideoController zzd = new VideoController();

    private zzrr(zzro zzro2) {
        this.zzb = zzro2;
        Context context = null;
        try {
            context = (Context)zzn.zza((IObjectWrapper)zzro2.zze());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzaky.zzb("Unable to inflate MediaView.", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Context context2 = context;
            mediaView = new MediaView(context2);
            try {
                if (!this.zzb.zza(zzn.zza((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                zzaky.zzb("Unable to render video in MediaView.", remoteException);
            }
        }
        this.zzc = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrr zza(zzro zzro2) {
        WeakHashMap<IBinder, zzrr> weakHashMap = zza;
        synchronized (weakHashMap) {
            zzrr zzrr2 = zza.get(zzro2.asBinder());
            if (zzrr2 != null) {
                return zzrr2;
            }
            zzrr2 = new zzrr(zzro2);
            zza.put(zzro2.asBinder(), zzrr2);
            return zzrr2;
        }
    }

    public final zzro zza() {
        return this.zzb;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzb.zza(string);
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get string.", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzqs zzqs2 = this.zzb.zzb(string);
            if (zzqs2 != null) {
                return new zzqv(zzqs2);
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get image.", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzmm zzmm2 = this.zzb.zzc();
            if (zzmm2 != null) {
                this.zzd.zza(zzmm2);
            }
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzd;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzc;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzb.zza();
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get available asset names.", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzb.zzl();
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to get custom template id.", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzb.zzc(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to perform click.", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzb.zzd();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to record impression.", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzb.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzaky.zzb("Failed to destroy ad.", remoteException);
            return;
        }
    }
}

