/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzjg;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzkm;
import com.google.android.gms.internal.ads.zzkp;
import com.google.android.gms.internal.ads.zzmg;
import com.google.android.gms.internal.ads.zzpy;
import com.google.android.gms.internal.ads.zzsl;
import com.google.android.gms.internal.ads.zzsm;
import com.google.android.gms.internal.ads.zzsn;
import com.google.android.gms.internal.ads.zzso;
import com.google.android.gms.internal.ads.zzsp;
import com.google.android.gms.internal.ads.zzsr;
import com.google.android.gms.internal.ads.zzym;

public class AdLoader {
    private final zzjn zzuv;
    private final Context mContext;
    private final zzkm zzuw;

    AdLoader(Context context, zzkm zzkm2) {
        this(context, zzkm2, zzjn.zzaup);
    }

    private AdLoader(Context context, zzkm zzkm2, zzjn zzjn2) {
        this.mContext = context;
        this.zzuw = zzkm2;
        this.zzuv = zzjn2;
    }

    private final void zza(zzmg zzmg2) {
        try {
            this.zzuw.zzd(zzjn.zza(this.mContext, zzmg2));
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzay());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzmg zzmg2 = adRequest.zzay();
        AdLoader adLoader = this;
        try {
            adLoader.zzuw.zza(zzjn.zza(adLoader.mContext, zzmg2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzay());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzuw.zzcj();
        }
        catch (RemoteException remoteException) {
            zzaok.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzuw.isLoading();
        }
        catch (RemoteException remoteException) {
            zzaok.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzkp zzux;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzkd.zzja().zzb(context, string, new zzym()));
        }

        private Builder(Context context, zzkp zzkp2) {
            this.mContext = context;
            this.zzux = zzkp2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzux.zza(new zzsm(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzux.zza(new zzsl(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzux.zza(new zzsr(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzux.zza(string, new zzso(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzsn(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzjo zzjo2 = new zzjo(this.mContext, adSizeArray);
                this.zzux.zza(new zzsp(onPublisherAdViewLoadedListener), zzjo2);
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzux.zzb(new zzjg(adListener));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzux.zza(new zzpy(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzux.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            Preconditions.checkNotNull((Object)correlator);
            try {
                this.zzux.zzb(correlator.zzvf);
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzux.zzdi());
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

