/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzly;
import com.google.android.gms.internal.ads.zzne;
import javax.annotation.concurrent.GuardedBy;

@zzaer
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private zzly zzvj;
    @GuardedBy(value="mLock")
    @Nullable
    private VideoLifecycleCallbacks zzvk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzly zzly2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzvj = zzly2;
            if (this.zzvk != null) {
                this.setVideoLifecycleCallbacks(this.zzvk);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzly zzbb() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzvj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return;
            }
            try {
                this.zzvj.play();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return;
            }
            try {
                this.zzvj.pause();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return;
            }
            try {
                this.zzvj.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return true;
            }
            try {
                return this.zzvj.isMuted();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return 0;
            }
            try {
                return this.zzvj.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return false;
            }
            try {
                return this.zzvj.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClickToExpandEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return false;
            }
            try {
                return this.zzvj.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        Preconditions.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzvk = videoLifecycleCallbacks;
            if (this.zzvj == null) {
                return;
            }
            try {
                this.zzvj.zza(new zzne(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzvk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzvj != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzvj == null) {
                return 0.0f;
            }
            try {
                return this.zzvj.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public VideoLifecycleCallbacks() {
        }

        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

