/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import android.util.JsonWriter;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaof;
import com.google.android.gms.internal.ads.zzaog;
import com.google.android.gms.internal.ads.zzaoh;
import com.google.android.gms.internal.ads.zzaoi;
import com.google.android.gms.internal.ads.zzaoj;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@zzaer
public final class zzaoe {
    private static Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean zzcys = false;
    @GuardedBy(value="sLock")
    private static boolean zzcyt = false;
    private static Clock zzacj = DefaultClock.getInstance();
    private static final Set<String> zzcyu = new HashSet<String>(Arrays.asList(new String[0]));
    private final List<String> zzcyv;

    public zzaoe() {
        this(null);
    }

    public zzaoe(@Nullable String string) {
        List<String> list;
        String string2 = string;
        if (!zzaoe.isEnabled()) {
            list = new ArrayList<String>();
        } else {
            String string3 = UUID.randomUUID().toString();
            if (string2 == null) {
                String[] stringArray = new String[1];
                String string4 = String.valueOf(string3);
                stringArray[0] = string4.length() != 0 ? "network_request_".concat(string4) : new String("network_request_");
                list = Arrays.asList(stringArray);
            } else {
                String[] stringArray = new String[2];
                String string5 = String.valueOf(string2);
                stringArray[0] = string5.length() != 0 ? "ad_request_".concat(string5) : new String("ad_request_");
                String string6 = String.valueOf(string3);
                stringArray[1] = string6.length() != 0 ? "network_request_".concat(string6) : new String("network_request_");
                list = Arrays.asList(stringArray);
            }
        }
        this.zzcyv = list;
    }

    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzaoe.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzb(string, string2, hashMap, byArray);
    }

    public final void zza(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzaoe.isEnabled()) {
            return;
        }
        this.zzb(string, string2, map, byArray);
    }

    private final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        this.zza("onNetworkRequest", new zzaof(string, string2, map, byArray));
    }

    public final void zza(HttpURLConnection httpURLConnection, int n) {
        if (!zzaoe.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getHeaderFields() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getHeaderFields());
        this.zzb(hashMap, n);
        if (n < 200 || n >= 300) {
            String string = null;
            try {
                string = httpURLConnection.getResponseMessage();
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException.getMessage());
                zzaok.zzdp(string2.length() != 0 ? "Can not get error message from error HttpURLConnection\n".concat(string2) : new String("Can not get error message from error HttpURLConnection\n"));
            }
            this.zzdm(string);
        }
    }

    public final void zza(@Nullable Map<String, ?> map, int n) {
        if (!zzaoe.isEnabled()) {
            return;
        }
        this.zzb(map, n);
        if (n < 200 || n >= 300) {
            this.zzdm(null);
        }
    }

    private final void zzb(@Nullable Map<String, ?> map, int n) {
        this.zza("onNetworkResponse", new zzaog(n, map));
    }

    public final void zzdl(@Nullable String string) {
        if (!zzaoe.isEnabled()) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.zzf(byArray);
    }

    public final void zzf(byte[] byArray) {
        this.zza("onNetworkResponseBody", new zzaoh(byArray));
    }

    private final void zzdm(@Nullable String string) {
        this.zza("onNetworkRequestError", new zzaoi(string));
    }

    private static void zza(JsonWriter jsonWriter, @Nullable Map<String, ?> map) throws IOException {
        if (map == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (zzcyu.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (String string2 : (List)entry.getValue()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(string2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzaok.e("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    private final void zza(String string, zzaoj zzaoj2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zzacj.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            for (String string2 : this.zzcyv) {
                jsonWriter.value(string2);
            }
            jsonWriter.endArray();
            zzaoj2.zza(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzaok.zzb("unable to log", iOException);
        }
        zzaoe.zzdn(stringWriter.toString());
    }

    private static synchronized void zzdn(String string) {
        zzaok.zzdo("GMA Debug BEGIN");
        for (int i = 0; i < string.length(); i += 4000) {
            int n = Math.min(i + 4000, string.length());
            String string2 = String.valueOf(string.substring(i, n));
            zzaok.zzdo(string2.length() != 0 ? "GMA Debug CONTENT ".concat(string2) : new String("GMA Debug CONTENT "));
        }
        zzaok.zzdo("GMA Debug FINISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zztx() {
        Object object = sLock;
        synchronized (object) {
            zzcys = false;
            zzcyt = false;
            zzaok.zzdp("Ad debug logging enablement is out of date.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzaf(boolean bl) {
        Object object = sLock;
        synchronized (object) {
            zzcys = true;
            zzcyt = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzty() {
        Object object = sLock;
        synchronized (object) {
            return zzcys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        Object object = sLock;
        synchronized (object) {
            return zzcys && zzcyt;
        }
    }

    public static boolean zzbk(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        zznl<Boolean> zznl2 = zznw.zzbcr;
        if (!zzkd.zzjd().zzd(zznl2).booleanValue()) {
            return false;
        }
        try {
            return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
        }
        catch (Exception exception) {
            zzaok.zzc("Fail to determine debug setting.", exception);
            return false;
        }
    }

    static final /* synthetic */ void zza(String string, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        if (string != null) {
            jsonWriter.name("error_description").value(string);
        }
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        int n = byArray.length;
        String string = Base64Utils.encode((byte[])byArray);
        if (n < 10000) {
            jsonWriter.name("body").value(string);
        } else {
            String string2 = zzaoa.zzdj(string);
            if (string2 != null) {
                jsonWriter.name("bodydigest").value(string2);
            }
        }
        jsonWriter.name("bodylength").value((long)n);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzaoe.zza(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzaoe.zza(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }
}

