/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaid;
import com.google.android.gms.internal.ads.zzaiq;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzaut;
import com.google.android.gms.internal.ads.zzjs;
import com.google.android.gms.internal.ads.zzjy;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzll;
import com.google.android.gms.internal.ads.zzmm;
import com.google.android.gms.internal.ads.zzmo;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzym;
import javax.annotation.concurrent.GuardedBy;

@zzaer
public final class zzml {
    @GuardedBy(value="lock")
    private static zzml zzaxa;
    private static final Object lock;
    private zzll zzaxb;
    private RewardedVideoAd zzaxc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzml zzjt() {
        Object object = lock;
        synchronized (object) {
            if (zzaxa == null) {
                zzaxa = new zzml();
            }
            return zzaxa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string, zzmo zzmo2) {
        Object object = lock;
        synchronized (object) {
            if (this.zzaxb != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                Bundle bundle = new Bundle();
                bundle.putBoolean("measurementEnabled", false);
                zzxt.zza(context, string, bundle);
                Context context2 = context;
                zzjs zzjs2 = zzkd.zzja();
                Context context3 = context2;
                this.zzaxb = (zzll)new zzjy(zzjs2, context2).zzc(context3, false);
                this.zzaxb.zza();
                this.zzaxb.zza(new zzym());
                if (string != null) {
                    this.zzaxb.zza(string, ObjectWrapper.wrap((Object)new zzmm(this, context)));
                }
            }
            catch (RemoteException remoteException) {
                zzaok.zzc("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzym zzym2;
            if (this.zzaxc != null) {
                return this.zzaxc;
            }
            zzym zzym3 = zzym2 = new zzym();
            Context context2 = context;
            zzjs zzjs2 = zzkd.zzja();
            Context context3 = context2;
            zzaid zzaid2 = (zzaid)new zzkb(zzjs2, context2, zzym3).zzc(context3, false);
            this.zzaxc = new zzaiq(context, zzaid2);
            return this.zzaxc;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzaxb != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzaxb.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzdo() {
        float f = 1.0f;
        if (this.zzaxb == null) {
            return 1.0f;
        }
        try {
            f = this.zzaxb.zzdo();
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzaxb != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzaxb.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzdp() {
        boolean bl = false;
        if (this.zzaxb == null) {
            return false;
        }
        try {
            bl = this.zzaxb.zzdp();
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzaxb != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzaxb.zzb(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String zzdq() {
        try {
            this.zzaxb.zzdq();
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to get version string.", remoteException);
        }
        return "";
    }

    public final void registerRtbAdapter(Class<? extends zzaut> clazz) {
        try {
            this.zzaxb.zzw(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    private zzml() {
    }

    static {
        lock = new Object();
    }
}

