/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzly;
import com.google.android.gms.internal.ads.zzqk;
import com.google.android.gms.internal.ads.zzqn;
import com.google.android.gms.internal.ads.zzrg;
import java.util.List;
import java.util.WeakHashMap;

@zzaer
public final class zzrj
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzrj> zzboc = new WeakHashMap();
    private final zzrg zzbod;
    private final MediaView zzboe;
    private final VideoController zzawr = new VideoController();

    @VisibleForTesting
    private zzrj(zzrg zzrg2) {
        this.zzbod = zzrg2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzrg2.zzlj());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzaok.zzb("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzbod.zzi(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzaok.zzb("", (Throwable)object);
            }
        }
        this.zzboe = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzrj zza(zzrg zzrg2) {
        WeakHashMap<IBinder, zzrj> weakHashMap = zzboc;
        synchronized (weakHashMap) {
            zzrj zzrj2 = zzboc.get(zzrg2.asBinder());
            if (zzrj2 != null) {
                return zzrj2;
            }
            zzrj2 = new zzrj(zzrg2);
            zzboc.put(zzrg2.asBinder(), zzrj2);
            return zzrj2;
        }
    }

    public final zzrg zzmb() {
        return this.zzbod;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzbod.zzar(string);
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzqk zzqk2 = this.zzbod.zzas(string);
            if (zzqk2 != null) {
                return new zzqn(zzqk2);
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzly zzly2 = this.zzbod.getVideoController();
            if (zzly2 != null) {
                this.zzawr.zza(zzly2);
            }
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzawr;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzboe;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzbod.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzbod.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzbod.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzbod.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzbod.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("", remoteException);
            return;
        }
    }
}

