/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzrj;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzi;

@zzaer
public final class zzzl
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzyt zzbyd;
    private NativeAdMapper zzbye;
    private UnifiedNativeAdMapper zzbyf;
    private NativeCustomTemplateAd zzbyg;

    public zzzl(zzyt zzyt2) {
        this.zzbyd = zzyt2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAppEvent.");
        try {
            this.zzbyd.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdClicked.");
        try {
            this.zzbyd.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdClosed.");
        try {
            this.zzbyd.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzbyd.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLeftApplication.");
        try {
            this.zzbyd.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdOpened.");
        try {
            this.zzbyd.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLoaded.");
        try {
            this.zzbyd.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdClicked.");
        try {
            this.zzbyd.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdClosed.");
        try {
            this.zzbyd.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzbyd.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLeftApplication.");
        try {
            this.zzbyd.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdOpened.");
        try {
            this.zzbyd.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLoaded.");
        try {
            this.zzbyd.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLoaded.");
        this.zzbye = nativeAdMapper;
        this.zzbyf = null;
        zzzl.zza(mediationNativeAdapter, this.zzbyf, this.zzbye);
        try {
            this.zzbyd.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLoaded.");
        this.zzbyf = unifiedNativeAdMapper;
        this.zzbye = null;
        zzzl.zza(mediationNativeAdapter, this.zzbyf, this.zzbye);
        try {
            this.zzbyd.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzzi());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzaok.zzco(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzbyg = nativeCustomTemplateAd;
        try {
            this.zzbyd.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzrj) {
            try {
                this.zzbyd.zzb(((zzrj)nativeCustomTemplateAd).zzmb(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzaok.zzd("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzaok.zzdp("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzbyd.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdOpened.");
        try {
            this.zzbyd.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdClosed.");
        try {
            this.zzbyd.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onAdLeftApplication.");
        try {
            this.zzbyd.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzbye;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzbyf;
        if (this.zzbyg == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzaok.zzd("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzaok.zzco("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzaok.zzco("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzaok.zzco("Adapter called onAdClicked.");
        try {
            this.zzbyd.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzbye;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzbyf;
        if (this.zzbyg == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzaok.zzd("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzaok.zzco("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzaok.zzco("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzaok.zzco("Adapter called onAdImpression.");
        try {
            this.zzbyd.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzaok.zzco("Adapter called onVideoEnd.");
        try {
            this.zzbyd.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzoh() {
        return this.zzbye;
    }

    public final UnifiedNativeAdMapper zzoi() {
        return this.zzbyf;
    }

    public final NativeCustomTemplateAd zzoj() {
        return this.zzbyg;
    }
}

