/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaok;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzqt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzqt zzvw;
    public static WeakHashMap<View, NativeAdViewHolder> zzvx = new WeakHashMap();
    private WeakReference<View> zzvy;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzaok.e("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzvx.get(view) != null) {
            zzaok.e("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzvx.put(view, this);
        this.zzvy = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzvw = zzkd.zzja().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zza((IObjectWrapper)nativeAd.zzbd());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zza((IObjectWrapper)unifiedNativeAd.zzbd());
    }

    private final void zza(IObjectWrapper iObjectWrapper) {
        View view = this.zzvy != null ? (View)this.zzvy.get() : null;
        if (view == null) {
            zzaok.zzdp("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzvx.containsKey(view)) {
            zzvx.put(view, this);
        }
        if (this.zzvw != null) {
            try {
                this.zzvw.zza(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzvw != null) {
            try {
                this.zzvw.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzaok.zzb("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzvy != null ? (View)this.zzvy.get() : null) != null) {
            zzvx.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzvw.zzc(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzaok.zzb("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

