/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.zzc;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzkd;

@zzaer
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public class zzjo
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzjo> CREATOR = new zzjp();
    @SafeParcelable.Field(id=2)
    public final String zzauq;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzaur;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zzjo[] zzaus;
    @SafeParcelable.Field(id=9)
    public final boolean zzaut;
    @SafeParcelable.Field(id=10)
    public final boolean zzauu;
    @SafeParcelable.Field(id=11)
    public boolean zzauv;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zzjo.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzjo zzf(Context context) {
        return new zzjo("320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static zzjo zzis() {
        return new zzjo("reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzjo() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzjo(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zzjo(Context var1_1, AdSize[] var2_2) {
        block11: {
            block10: {
                super();
                var3_3 = var2_2[0];
                this.zzaur = false;
                this.zzauu = var3_3.isFluid();
                if (this.zzauu) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block10;
                zzkd.zziz();
                if (!zzaoa.zzbh(var1_1)) ** GOTO lbl-1000
                zzkd.zziz();
                if (zzaoa.zzbi(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzkd.zziz();
                    this.widthPixels = v0 - zzaoa.zzbj(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_10 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_10;
                }
                break block11;
            }
            var7_10 = this.width;
            zzkd.zziz();
            this.widthPixels = zzaoa.zza(var6_6, this.width);
        }
        var8_11 = var5_5 != false ? zzjo.zzd(var6_6) : this.height;
        zzkd.zziz();
        this.heightPixels = zzaoa.zza(var6_6, var8_11);
        if (var4_4 || var5_5) {
            var9_8 = var7_10;
            this.zzauq = new StringBuilder(26).append(var9_8).append("x").append(var8_11).append("_as").toString();
        } else {
            this.zzauq = this.zzauu != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzaus = new zzjo[var2_2.length];
            for (var9_9 = 0; var9_9 < var2_2.length; ++var9_9) {
                this.zzaus[var9_9] = new zzjo(var1_1, var2_2[var9_9]);
            }
        } else {
            this.zzaus = null;
        }
        this.zzaut = false;
        this.zzauv = false;
    }

    public zzjo(zzjo zzjo2, zzjo[] zzjoArray) {
        this(zzjo2.zzauq, zzjo2.height, zzjo2.heightPixels, zzjo2.zzaur, zzjo2.width, zzjo2.widthPixels, zzjoArray, zzjo2.zzaut, zzjo2.zzauu, zzjo2.zzauv);
    }

    @SafeParcelable.Constructor
    zzjo(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzjo[] zzjoArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4) {
        this.zzauq = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzaur = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzaus = zzjoArray;
        this.zzaut = bl2;
        this.zzauu = bl3;
        this.zzauv = bl4;
    }

    public final AdSize zzit() {
        return zzc.zza(this.width, this.height, this.zzauq);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzjo zzjo2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzjo2.zzauq, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzjo2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzjo2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zzjo2.zzaur);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zzjo2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzjo2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zzjo2.zzaus, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzjo2.zzaut);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzjo2.zzauu);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzjo2.zzauv);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

