/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaar;
import com.google.android.gms.internal.ads.zzaaz;
import com.google.android.gms.internal.ads.zzabc;
import com.google.android.gms.internal.ads.zzacd;
import com.google.android.gms.internal.ads.zzadr;
import com.google.android.gms.internal.ads.zzamo;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzxs;
import com.google.android.gms.internal.ads.zzxv;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzyf;
import com.google.android.gms.internal.ads.zzyg;
import com.google.android.gms.internal.ads.zzyh;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyk;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzyv;
import com.google.android.gms.internal.ads.zzzk;
import java.util.concurrent.atomic.AtomicBoolean;

@zzard
public final class zzabb {
    private final zzamo zzcjc = new zzamo();
    private final zzyc zzaaj;
    private final AtomicBoolean zzcjd;
    private final VideoController zzcje = new VideoController();
    @VisibleForTesting
    private final zzyv zzcjf = new zzabc(this);
    private zzxr zzcgi;
    private AdListener zzcgl;
    private AdSize[] zzchj;
    private AppEventListener zzbqp;
    private Correlator zzcjg;
    private zzzk zzcjh;
    private OnCustomRenderedAdLoadedListener zzcji;
    private VideoOptions zzbqg;
    private String zzchk;
    private ViewGroup zzcjj;
    private int zzcjk;
    private boolean zzbqn;

    public zzabb(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzyc.zzche, 0);
    }

    public zzabb(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzyc.zzche, n);
    }

    public zzabb(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzyc.zzche, 0);
    }

    public zzabb(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzyc.zzche, n);
    }

    @VisibleForTesting
    private zzabb(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzyc zzyc2, zzzk zzzk2, int n) {
        this.zzcjj = viewGroup;
        this.zzaaj = zzyc2;
        this.zzcjh = null;
        this.zzcjd = new AtomicBoolean(false);
        this.zzcjk = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzyg zzyg2 = new zzyg(context, attributeSet);
                this.zzchj = zzyg2.zzs(bl);
                this.zzchk = zzyg2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzyt.zzpa().zza(viewGroup, new zzyd(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzcjk;
                AdSize adSize = this.zzchj[0];
                Context context2 = context;
                zzyd zzyd2 = new zzyd(context2, adSize);
                new zzyd(context2, adSize).zzchi = bl2 = zzabb.zzcp(n2);
                zzyt.zzpa().zza(viewGroup, zzyd2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzabb(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzyc zzyc2, int n) {
        this(viewGroup, attributeSet, bl, zzyc2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzcjh != null) {
                this.zzcjh.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcgl;
    }

    public final AdSize getAdSize() {
        try {
            zzyd zzyd2;
            if (this.zzcjh != null && (zzyd2 = this.zzcjh.zzpn()) != null) {
                zzyd zzyd3 = zzyd2;
                return zzb.zza(zzyd3.width, zzyd3.height, zzyd3.zzaap);
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzchj != null) {
            return this.zzchj[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzchj;
    }

    public final String getAdUnitId() {
        if (this.zzchk == null && this.zzcjh != null) {
            try {
                this.zzchk = this.zzcjh.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzbad.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzchk;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbqp;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcji;
    }

    public final void zza(zzaaz zzaaz2) {
        try {
            if (this.zzcjh == null) {
                zzzk zzzk2;
                zzyd zzyd2;
                zzabb zzabb2 = this;
                if ((zzabb2.zzchj == null || zzabb2.zzchk == null) && zzabb2.zzcjh == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzabb zzabb3 = zzabb2;
                Context context = zzabb3.zzcjj.getContext();
                Object object = zzyd2 = zzabb.zza(context, zzabb3.zzchj, zzabb3.zzcjk);
                if ("search_v2".equals(object.zzaap)) {
                    String string = zzabb3.zzchk;
                    zzyd zzyd3 = zzyd2;
                    Context context2 = context;
                    object = zzyt.zzpb();
                    Context context3 = context2;
                    zzzk2 = (zzzk)new zzyk((zzyh)object, context2, zzyd3, string).zzd(context3, false);
                } else {
                    zzamo zzamo2 = zzabb3.zzcjc;
                    String string = zzabb3.zzchk;
                    zzyd zzyd4 = zzyd2;
                    Context context4 = context;
                    object = zzyt.zzpb();
                    Context context5 = context4;
                    zzzk2 = (zzzk)new zzyi((zzyh)object, context4, zzyd4, string, zzamo2).zzd(context5, false);
                }
                zzabb2.zzcjh = zzzk2;
                zzabb2.zzcjh.zzb(new zzxv(zzabb2.zzcjf));
                if (zzabb2.zzcgi != null) {
                    zzabb2.zzcjh.zza(new zzxs(zzabb2.zzcgi));
                }
                if (zzabb2.zzbqp != null) {
                    zzabb2.zzcjh.zza(new zzyf(zzabb2.zzbqp));
                }
                if (zzabb2.zzcji != null) {
                    zzabb2.zzcjh.zza(new zzadr(zzabb2.zzcji));
                }
                if (zzabb2.zzcjg != null) {
                    zzabb2.zzcjh.zzb(zzabb2.zzcjg.zzdf());
                }
                if (zzabb2.zzbqg != null) {
                    zzabb2.zzcjh.zza(new zzacd(zzabb2.zzbqg));
                }
                zzabb2.zzcjh.setManualImpressionsEnabled(zzabb2.zzbqn);
                zzabb zzabb4 = zzabb2;
                try {
                    IObjectWrapper iObjectWrapper = zzabb4.zzcjh.zzpl();
                    if (iObjectWrapper != null) {
                        zzabb4.zzcjj.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzbad.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzcjh.zzb(zzyc.zza(this.zzcjj.getContext(), zzaaz2))) {
                this.zzcjc.zzf(zzaaz2.zzqa());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzcjh != null) {
                this.zzcjh.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcjd.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzcjh != null) {
                this.zzcjh.zzpm();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzcjh != null) {
                this.zzcjh.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcgl = adListener;
        this.zzcjf.zza(adListener);
    }

    public final void zza(zzxr zzxr2) {
        try {
            this.zzcgi = zzxr2;
            if (this.zzcjh != null) {
                this.zzcjh.zza(zzxr2 != null ? new zzxs(zzxr2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzchj != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzchj = adSizeArray;
        try {
            if (this.zzcjh != null) {
                this.zzcjh.zza(zzabb.zza(this.zzcjj.getContext(), this.zzchj, this.zzcjk));
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzcjj.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzchk != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzchk = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbqp = appEventListener;
            if (this.zzcjh != null) {
                this.zzcjh.zza(appEventListener != null ? new zzyf(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcji = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzcjh != null) {
                this.zzcjh.zza(onCustomRenderedAdLoadedListener != null ? new zzadr(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbqn = bl;
        try {
            if (this.zzcjh != null) {
                this.zzcjh.setManualImpressionsEnabled(this.zzbqn);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzcjg = correlator;
        try {
            if (this.zzcjh != null) {
                this.zzcjh.zzb(this.zzcjg == null ? null : this.zzcjg.zzdf());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzcjh != null) {
                return this.zzcjh.zzpj();
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzcjh != null) {
                return this.zzcjh.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzcje;
    }

    public final zzaar zzdh() {
        if (this.zzcjh == null) {
            return null;
        }
        try {
            return this.zzcjh.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzbqg = videoOptions;
        try {
            if (this.zzcjh != null) {
                this.zzcjh.zza(videoOptions == null ? null : new zzacd(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzbqg;
    }

    public final boolean zza(zzzk zzzk2) {
        IObjectWrapper iObjectWrapper;
        if (zzzk2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzzk2.zzpl();
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzcjj.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzcjh = zzzk2;
        return true;
    }

    private static zzyd zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzyd zzyd2 = new zzyd(context, adSizeArray);
        new zzyd(context, adSizeArray).zzchi = bl = zzabb.zzcp(n);
        return zzyd2;
    }

    private static boolean zzcp(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzabb zzabb2) {
        return zzabb2.zzcje;
    }
}

