/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzafh;
import com.google.android.gms.internal.ads.zzamv;
import com.google.android.gms.internal.ads.zzanj;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzbad;

@zzard
public final class zzano
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzamv zzdgl;
    private NativeAdMapper zzdgm;
    private UnifiedNativeAdMapper zzdgn;
    private NativeCustomTemplateAd zzdgo;

    public zzano(zzamv zzamv2) {
        this.zzdgl = zzamv2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAppEvent.");
        try {
            this.zzdgl.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgl.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgl.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzdgl.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgl.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgl.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLoaded.");
        try {
            this.zzdgl.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgl.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgl.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgl.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgl.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgl.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLoaded.");
        try {
            this.zzdgl.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLoaded.");
        this.zzdgm = nativeAdMapper;
        this.zzdgn = null;
        zzano.zza(mediationNativeAdapter, this.zzdgn, this.zzdgm);
        try {
            this.zzdgl.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLoaded.");
        this.zzdgn = unifiedNativeAdMapper;
        this.zzdgm = null;
        zzano.zza(mediationNativeAdapter, this.zzdgn, this.zzdgm);
        try {
            this.zzdgl.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzanj());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzbad.zzdp(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzdgo = nativeCustomTemplateAd;
        try {
            this.zzdgl.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzafh) {
            try {
                this.zzdgl.zza(((zzafh)nativeCustomTemplateAd).zzrn(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzbad.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzbad.zzep("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgl.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgl.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgl.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgl.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgm;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgn;
        if (this.zzdgo == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzbad.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzbad.zzdp("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzbad.zzdp("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzbad.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgl.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgm;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgn;
        if (this.zzdgo == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzbad.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzbad.zzdp("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzbad.zzdp("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzbad.zzdp("Adapter called onAdImpression.");
        try {
            this.zzdgl.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbad.zzdp("Adapter called onVideoEnd.");
        try {
            this.zzdgl.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzbad.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzsr() {
        return this.zzdgm;
    }

    public final UnifiedNativeAdMapper zzss() {
        return this.zzdgn;
    }

    public final NativeCustomTemplateAd zzst() {
        return this.zzdgo;
    }
}

