/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.JsonWriter;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzazy;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbaa;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbac;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzyt;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@zzard
public final class zzazx {
    private static Object lock = new Object();
    @GuardedBy(value="lock")
    private static boolean zzdyv = false;
    @GuardedBy(value="lock")
    private static boolean enabled = false;
    private static Clock zzbsa = DefaultClock.getInstance();
    private static final Set<String> zzdyw = new HashSet<String>(Arrays.asList(new String[0]));
    private final List<String> zzdyx;

    public zzazx() {
        this(null);
    }

    public zzazx(@Nullable String string) {
        List<String> list;
        if (!zzazx.isEnabled()) {
            list = new ArrayList<String>();
        } else {
            String string2 = UUID.randomUUID().toString();
            String[] stringArray = new String[1];
            String string3 = String.valueOf(string2);
            stringArray[0] = string3.length() != 0 ? "network_request_".concat(string3) : new String("network_request_");
            list = Arrays.asList(stringArray);
        }
        this.zzdyx = list;
    }

    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzazx.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzb(string, string2, hashMap, byArray);
    }

    public final void zza(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzazx.isEnabled()) {
            return;
        }
        this.zzb(string, string2, map, byArray);
    }

    private final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        this.zza("onNetworkRequest", new zzazy(string, string2, map, byArray));
    }

    public final void zza(HttpURLConnection httpURLConnection, int n) {
        if (!zzazx.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getHeaderFields() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getHeaderFields());
        this.zzb(hashMap, n);
        if (n < 200 || n >= 300) {
            String string = null;
            try {
                string = httpURLConnection.getResponseMessage();
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException.getMessage());
                zzbad.zzep(string2.length() != 0 ? "Can not get error message from error HttpURLConnection\n".concat(string2) : new String("Can not get error message from error HttpURLConnection\n"));
            }
            this.zzel(string);
        }
    }

    public final void zza(@Nullable Map<String, ?> map, int n) {
        if (!zzazx.isEnabled()) {
            return;
        }
        this.zzb(map, n);
        if (n < 200 || n >= 300) {
            this.zzel(null);
        }
    }

    private final void zzb(@Nullable Map<String, ?> map, int n) {
        this.zza("onNetworkResponse", new zzazz(n, map));
    }

    public final void zzek(@Nullable String string) {
        if (!zzazx.isEnabled()) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.zzj(byArray);
    }

    public final void zzj(byte[] byArray) {
        this.zza("onNetworkResponseBody", new zzbaa(byArray));
    }

    private final void zzel(@Nullable String string) {
        this.zza("onNetworkRequestError", new zzbab(string));
    }

    private static void zza(JsonWriter jsonWriter, @Nullable Map<String, ?> map) throws IOException {
        if (map == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (zzdyw.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (String string2 : (List)entry.getValue()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(string2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzbad.zzen("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    private final void zza(String string, zzbac zzbac2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zzbsa.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            for (String string2 : this.zzdyx) {
                jsonWriter.value(string2);
            }
            jsonWriter.endArray();
            zzbac2.zzb(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzbad.zzc("unable to log", iOException);
        }
        zzazx.zzem(stringWriter.toString());
    }

    private static synchronized void zzem(String string) {
        zzbad.zzeo("GMA Debug BEGIN");
        for (int i = 0; i < string.length(); i += 4000) {
            int n = Math.min(i + 4000, string.length());
            String string2 = String.valueOf(string.substring(i, n));
            zzbad.zzeo(string2.length() != 0 ? "GMA Debug CONTENT ".concat(string2) : new String("GMA Debug CONTENT "));
        }
        zzbad.zzeo("GMA Debug FINISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzxa() {
        Object object = lock;
        synchronized (object) {
            zzdyv = false;
            enabled = false;
            zzbad.zzep("Ad debug logging enablement is out of date.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzal(boolean bl) {
        Object object = lock;
        synchronized (object) {
            zzdyv = true;
            enabled = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzxb() {
        Object object = lock;
        synchronized (object) {
            return zzdyv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        Object object = lock;
        synchronized (object) {
            return zzdyv && enabled;
        }
    }

    public static boolean zzbk(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        zzacj<Boolean> zzacj2 = zzacu.zzcqb;
        if (!zzyt.zzpe().zzd(zzacj2).booleanValue()) {
            return false;
        }
        try {
            return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
        }
        catch (Exception exception) {
            zzbad.zzd("Fail to determine debug setting.", exception);
            return false;
        }
    }

    static final /* synthetic */ void zza(String string, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        if (string != null) {
            jsonWriter.name("error_description").value(string);
        }
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        int n = byArray.length;
        String string = Base64Utils.encode((byte[])byArray);
        if (n < 10000) {
            jsonWriter.name("body").value(string);
        } else {
            String string2 = zzazt.zzei(string);
            if (string2 != null) {
                jsonWriter.name("bodydigest").value(string2);
            }
        }
        jsonWriter.name("bodylength").value((long)n);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzazx.zza(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzazx.zza(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }
}

