/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzach;
import com.google.android.gms.internal.ads.zzaew;
import com.google.android.gms.internal.ads.zzaex;
import com.google.android.gms.internal.ads.zzaey;
import com.google.android.gms.internal.ads.zzaez;
import com.google.android.gms.internal.ads.zzafb;
import com.google.android.gms.internal.ads.zzafd;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzui;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzvp;
import com.google.android.gms.internal.ads.zzvq;
import com.google.android.gms.internal.ads.zzxr;

public class AdLoader {
    private final zzui zzabf;
    private final Context zzur;
    private final zzvp zzabg;

    AdLoader(Context context, zzvp zzvp2) {
        this(context, zzvp2, zzui.zzcdb);
    }

    private AdLoader(Context context, zzvp zzvp2, zzui zzui2) {
        this.zzur = context;
        this.zzabg = zzvp2;
        this.zzabf = zzui2;
    }

    private final void zza(zzxr zzxr2) {
        try {
            this.zzabg.zzb(zzui.zza(this.zzur, zzxr2));
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzdl());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzxr zzxr2 = adRequest.zzdl();
        AdLoader adLoader = this;
        try {
            adLoader.zzabg.zza(zzui.zza(adLoader.zzur, zzxr2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzdl());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzabg.zzkf();
        }
        catch (RemoteException remoteException) {
            zzazh.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzabg.isLoading();
        }
        catch (RemoteException remoteException) {
            zzazh.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzur;
        private final zzvq zzabe;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzvh.zzpa().zzb(context, string, new zzall()));
        }

        private Builder(Context context, zzvq zzvq2) {
            this.zzur = context;
            this.zzabe = zzvq2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzabe.zza(new zzaew(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzabe.zza(new zzaex(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzabe.zza(new zzafd(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzabe.zza(string, new zzaey(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzaez(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzuk zzuk2 = new zzuk(this.zzur, adSizeArray);
                this.zzabe.zza(new zzafb(onPublisherAdViewLoadedListener), zzuk2);
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzabe.zzb(new zzud(adListener));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzabe.zza(new zzach(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzabe.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzazh.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        @Deprecated
        @KeepForSdk
        public Builder withCorrelator(@NonNull Correlator correlator) {
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzur, this.zzabe.zzpi());
            }
            catch (RemoteException remoteException) {
                zzazh.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

