/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzxq;
import com.google.android.gms.internal.ads.zzxr;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzxr zzabh;

    private AdRequest(Builder builder) {
        this.zzabh = new zzxr(builder.zzabi);
    }

    @Deprecated
    public final Date getBirthday() {
        return this.zzabh.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzabh.getContentUrl();
    }

    public final List<String> getNeighboringContentUrls() {
        return this.zzabh.zzpp();
    }

    @Deprecated
    public final int getGender() {
        return this.zzabh.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzabh.getKeywords();
    }

    public final Location getLocation() {
        return this.zzabh.getLocation();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzabh.getNetworkExtras(clazz);
    }

    public final <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzabh.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzabh.getCustomEventExtrasBundle(clazz);
    }

    public final boolean isTestDevice(Context context) {
        return this.zzabh.isTestDevice(context);
    }

    public final zzxr zzdl() {
        return this.zzabh;
    }

    /* synthetic */ AdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzxq zzabi = new zzxq();

        public Builder() {
            this.zzabi.zzch(AdRequest.DEVICE_ID_EMULATOR);
        }

        public final Builder addKeyword(String string) {
            this.zzabi.zzcg(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzabi.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationExtrasReceiver> clazz, Bundle bundle) {
            this.zzabi.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zzabi.zzci(AdRequest.DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzabi.zzb(clazz, bundle);
            return this;
        }

        @Deprecated
        public final Builder addTestDevice(String string) {
            this.zzabi.zzch(string);
            return this;
        }

        public final AdRequest build() {
            return new AdRequest(this, null);
        }

        @Deprecated
        public final Builder setBirthday(Date date) {
            this.zzabi.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzabi.zzcj(string);
            return this;
        }

        public final Builder setNeighboringContentUrls(List<String> list) {
            if (list == null) {
                zzazh.zzfa("neighboring content URLs list should not be null");
                return this;
            }
            this.zzabi.zzb(list);
            return this;
        }

        @Deprecated
        public final Builder setGender(int n) {
            this.zzabi.zzck(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzabi.zza(location);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzabi.zzcl(string);
            return this;
        }

        @Deprecated
        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzabi.zzz(bl);
            return this;
        }

        @Deprecated
        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzabi.zzaa(bl);
            return this;
        }

        @KeepForSdk
        public final Builder setAdInfo(AdInfo adInfo) {
            this.zzabi.zza(adInfo);
            return this;
        }

        @Deprecated
        public final Builder setTagForUnderAgeOfConsent(int n) {
            this.zzabi.zzcl(n);
            return this;
        }

        @Deprecated
        public final Builder setMaxAdContentRating(String string) {
            this.zzabi.zzcn(string);
            return this;
        }
    }
}

