/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import com.google.android.gms.ads.zzc;
import com.google.android.gms.internal.ads.zzazh;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class RequestConfiguration {
    private final int zzabv;
    private final int zzabw;
    private final String zzabx;
    private final List<String> zzaby;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final List<String> zzabz = Arrays.asList("MA", "T", "PG", "G");

    private RequestConfiguration(int n, int n2, String string, List<String> list) {
        this.zzabv = n;
        this.zzabw = n2;
        this.zzabx = string;
        this.zzaby = list;
    }

    public int getTagForChildDirectedTreatment() {
        return this.zzabv;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzabw;
    }

    public String getMaxAdContentRating() {
        if (this.zzabx == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return this.zzabx;
    }

    public List<String> getTestDeviceIds() {
        return new ArrayList<String>(this.zzaby);
    }

    public Builder toBuilder() {
        return new Builder().setTagForChildDirectedTreatment(this.zzabv).setTagForUnderAgeOfConsent(this.zzabw).setMaxAdContentRating(this.zzabx).setTestDeviceIds(this.zzaby);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, List list, zzc zzc2) {
        this(n, n2, string, list);
    }

    public static class Builder {
        private int zzabv = -1;
        private int zzabw = -1;
        private String zzabx = null;
        private final List<String> zzaby = new ArrayList<String>();

        public RequestConfiguration build() {
            return new RequestConfiguration(this.zzabv, this.zzabw, this.zzabx, this.zzaby, null);
        }

        public Builder setTagForChildDirectedTreatment(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabv = n;
            } else {
                zzazh.zzfa(new StringBuilder(68).append("Invalid value passed to setTagForChildDirectedTreatment: ").append(n).toString());
            }
            return this;
        }

        public Builder setTagForUnderAgeOfConsent(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabw = n;
            } else {
                zzazh.zzfa(new StringBuilder(63).append("Invalid value passed to setTagForUnderAgeOfConsent: ").append(n).toString());
            }
            return this;
        }

        public Builder setMaxAdContentRating(String string) {
            if (string == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(string)) {
                this.zzabx = null;
            } else if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(string)) {
                this.zzabx = string;
            } else {
                String string2 = String.valueOf(string);
                zzazh.zzfa(string2.length() != 0 ? "Invalid value passed to setMaxAdContentRating: ".concat(string2) : new String("Invalid value passed to setMaxAdContentRating: "));
            }
            return this;
        }

        public Builder setTestDeviceIds(@Nullable List<String> list) {
            this.zzaby.clear();
            if (list != null) {
                this.zzaby.addAll(list);
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

