/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzado;
import com.google.android.gms.internal.ads.zzalq;
import com.google.android.gms.internal.ads.zzame;
import com.google.android.gms.internal.ads.zzazh;

public final class zzaml
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzalq zzdex;
    private NativeAdMapper zzdey;
    private UnifiedNativeAdMapper zzdez;
    private NativeCustomTemplateAd zzdfa;

    public zzaml(zzalq zzalq2) {
        this.zzdex = zzalq2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAppEvent.");
        try {
            this.zzdex.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdClicked.");
        try {
            this.zzdex.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdClosed.");
        try {
            this.zzdex.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzdex.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLeftApplication.");
        try {
            this.zzdex.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdOpened.");
        try {
            this.zzdex.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLoaded.");
        try {
            this.zzdex.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdClicked.");
        try {
            this.zzdex.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdClosed.");
        try {
            this.zzdex.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdex.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLeftApplication.");
        try {
            this.zzdex.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdOpened.");
        try {
            this.zzdex.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLoaded.");
        try {
            this.zzdex.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLoaded.");
        this.zzdey = nativeAdMapper;
        this.zzdez = null;
        zzaml.zza(mediationNativeAdapter, this.zzdez, this.zzdey);
        try {
            this.zzdex.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLoaded.");
        this.zzdez = unifiedNativeAdMapper;
        this.zzdey = null;
        zzaml.zza(mediationNativeAdapter, this.zzdez, this.zzdey);
        try {
            this.zzdex.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzame());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzazh.zzeb(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzdfa = nativeCustomTemplateAd;
        try {
            this.zzdex.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzado) {
            try {
                this.zzdex.zza(((zzado)nativeCustomTemplateAd).zzrs(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzazh.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzazh.zzfa("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdex.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdOpened.");
        try {
            this.zzdex.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdClosed.");
        try {
            this.zzdex.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onAdLeftApplication.");
        try {
            this.zzdex.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdey;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdez;
        if (this.zzdfa == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzazh.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzazh.zzeb("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzazh.zzeb("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzazh.zzeb("Adapter called onAdClicked.");
        try {
            this.zzdex.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdey;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdez;
        if (this.zzdfa == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzazh.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzazh.zzeb("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzazh.zzeb("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzazh.zzeb("Adapter called onAdImpression.");
        try {
            this.zzdex.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzazh.zzeb("Adapter called onVideoEnd.");
        try {
            this.zzdex.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zztb() {
        return this.zzdey;
    }

    public final UnifiedNativeAdMapper zztc() {
        return this.zzdez;
    }

    public final NativeCustomTemplateAd zztd() {
        return this.zzdfa;
    }
}

