/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzabo;
import com.google.android.gms.internal.ads.zzapz;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzaqd;
import com.google.android.gms.internal.ads.zzaqe;
import com.google.android.gms.internal.ads.zzayx;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzazl;
import com.google.android.gms.internal.ads.zzazo;
import com.google.android.gms.internal.ads.zzdkl;
import com.google.android.gms.internal.ads.zzdkm;
import com.google.android.gms.internal.ads.zzdww;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzzx;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzaqa
implements zzaqe {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzaqe zzdjk = null;
    @VisibleForTesting
    private static zzaqe zzdjl = null;
    private final Object zzdjm = new Object();
    private final Context zzcgw;
    private final WeakHashMap<Thread, Boolean> zzdjn = new WeakHashMap();
    private final ExecutorService zzxo = zzdkl.zzatr().zzdt(zzdkm.zzgym);
    private final zzazo zzdjo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaqe zzu(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdjk == null) {
                zzdjk = zzabo.zzcvl.get() != false ? new zzaqa(context) : new zzaqd();
            }
        }
        return zzdjk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaqe zzc(Context context, zzazo zzazo2) {
        Object object = lock;
        synchronized (object) {
            if (zzdjl == null) {
                if (zzabo.zzcvl.get().booleanValue()) {
                    zzaqa zzaqa2 = new zzaqa(context, zzazo2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzaqa zzaqa3 = zzaqa2;
                    if (thread != null) {
                        Object object2 = zzaqa3.zzdjm;
                        synchronized (object2) {
                            zzaqa3.zzdjn.put(thread, true);
                        }
                        object2 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzaqb(zzaqa3, (Thread.UncaughtExceptionHandler)object2));
                    }
                    zzaqa zzaqa4 = zzaqa2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzaqc(zzaqa4, uncaughtExceptionHandler));
                    zzdjl = zzaqa2;
                } else {
                    zzdjl = new zzaqd();
                }
            }
        }
        return zzdjl;
    }

    private zzaqa(Context context) {
        this(context, zzazo.zzxr());
    }

    private zzaqa(Context context, zzazo zzazo2) {
        this.zzcgw = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdjo = zzazo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzaqa zzaqa2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzayx.zzeu(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzaqa2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzayx.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdww.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzaqa zzaqa2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzazl zzazl2 = new zzazl();
                zzaqa2.zzxo.execute(new zzapz(zzazl2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzcgw).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzazh.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzcgw.getPackageName();
        }
        catch (Throwable throwable) {
            zzazh.zzfa("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdjo.zzbmj).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzzx.zzqj())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "296073839").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzvh.zzpe()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzabo.zzcvj.get()));
    }

    static final /* synthetic */ void zza(zzazl zzazl2, String string) {
        zzazl2.zzeo(string);
    }
}

