/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdxh;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdzi;
import com.google.android.gms.internal.ads.zzeat;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdyl
extends zzdxh<Double>
implements zzdzi<Double>,
zzeat,
RandomAccess {
    private static final zzdyl zzhpm = new zzdyl(new double[0], 0);
    private double[] zzhpn;
    private int size;

    zzdyl() {
        this(new double[10], 0);
    }

    private zzdyl(double[] dArray, int n) {
        this.zzhpn = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbao();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhpn, n2, this.zzhpn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdyl)) {
            return super.equals(object);
        }
        zzdyl zzdyl2 = (zzdyl)object;
        if (this.size != zzdyl2.size) {
            return false;
        }
        double[] dArray = zzdyl2.zzhpn;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhpn[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhpn[i]);
            n = n * 31 + zzdzc.zzfr(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzbao();
        if (this.size == this.zzhpn.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhpn, 0, dArray, 0, this.size);
            this.zzhpn = dArray;
        }
        this.zzhpn[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzbao();
        zzdzc.checkNotNull(collection);
        if (!(collection instanceof zzdyl)) {
            return super.addAll(collection);
        }
        zzdyl zzdyl2 = (zzdyl)collection;
        if (zzdyl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdyl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdyl2.size;
        if (n > this.zzhpn.length) {
            this.zzhpn = Arrays.copyOf(this.zzhpn, n);
        }
        System.arraycopy(zzdyl2.zzhpn, 0, this.zzhpn, this.size, zzdyl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbao();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhpn[i])) continue;
            System.arraycopy(this.zzhpn, i + 1, this.zzhpn, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfb(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfc(n));
        }
    }

    private final String zzfc(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdyl zzdyl2 = this;
        zzdyl2.zzbao();
        zzdyl2.zzfb(n);
        double d3 = zzdyl2.zzhpn[n];
        zzdyl2.zzhpn[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdyl zzdyl2 = this;
        zzdyl2.zzbao();
        zzdyl2.zzfb(n);
        double d = zzdyl2.zzhpn[n];
        if (n < zzdyl2.size - 1) {
            System.arraycopy(zzdyl2.zzhpn, n + 1, zzdyl2.zzhpn, n, zzdyl2.size - n - 1);
        }
        --zzdyl2.size;
        ++zzdyl2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdyl zzdyl2 = this;
        zzdyl2.zzbao();
        if (n < 0 || n > zzdyl2.size) {
            throw new IndexOutOfBoundsException(zzdyl2.zzfc(n));
        }
        if (zzdyl2.size < zzdyl2.zzhpn.length) {
            System.arraycopy(zzdyl2.zzhpn, n, zzdyl2.zzhpn, n + 1, zzdyl2.size - n);
        } else {
            double[] dArray = new double[zzdyl2.size * 3 / 2 + 1];
            System.arraycopy(zzdyl2.zzhpn, 0, dArray, 0, n);
            System.arraycopy(zzdyl2.zzhpn, n, dArray, n + 1, zzdyl2.size - n);
            zzdyl2.zzhpn = dArray;
        }
        zzdyl2.zzhpn[n] = d2;
        ++zzdyl2.size;
        ++zzdyl2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzd(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzdzi zzfd(int n) {
        int n2 = n;
        zzdyl zzdyl2 = this;
        if (n2 < zzdyl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdyl(Arrays.copyOf(zzdyl2.zzhpn, n2), zzdyl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdyl zzdyl2 = this;
        zzdyl2.zzfb(n);
        return zzdyl2.zzhpn[n];
    }

    static {
        zzhpm.zzban();
    }
}

