/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdxh;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdzg;
import com.google.android.gms.internal.ads.zzdzi;
import com.google.android.gms.internal.ads.zzeat;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdza
extends zzdxh<Integer>
implements zzdzg,
zzeat,
RandomAccess {
    private static final zzdza zzhta = new zzdza(new int[0], 0);
    private int[] zzhtb;
    private int size;

    public static zzdza zzbdg() {
        return zzhta;
    }

    zzdza() {
        this(new int[10], 0);
    }

    private zzdza(int[] nArray, int n) {
        this.zzhtb = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbao();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhtb, n2, this.zzhtb, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdza)) {
            return super.equals(object);
        }
        zzdza zzdza2 = (zzdza)object;
        if (this.size != zzdza2.size) {
            return false;
        }
        int[] nArray = zzdza2.zzhtb;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhtb[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzhtb[i];
        }
        return n;
    }

    @Override
    public final zzdzg zzgk(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzdza(Arrays.copyOf(this.zzhtb, n), this.size);
    }

    public final int getInt(int n) {
        this.zzfb(n);
        return this.zzhtb[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzgl(int n) {
        this.zzbao();
        if (this.size == this.zzhtb.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhtb, 0, nArray, 0, this.size);
            this.zzhtb = nArray;
        }
        this.zzhtb[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzbao();
        zzdzc.checkNotNull(collection);
        if (!(collection instanceof zzdza)) {
            return super.addAll(collection);
        }
        zzdza zzdza2 = (zzdza)collection;
        if (zzdza2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdza2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdza2.size;
        if (n > this.zzhtb.length) {
            this.zzhtb = Arrays.copyOf(this.zzhtb, n);
        }
        System.arraycopy(zzdza2.zzhtb, 0, this.zzhtb, this.size, zzdza2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbao();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhtb[i])) continue;
            System.arraycopy(this.zzhtb, i + 1, this.zzhtb, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfb(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfc(n));
        }
    }

    private final String zzfc(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdza zzdza2 = this;
        zzdza2.zzbao();
        zzdza2.zzfb(n);
        int n4 = zzdza2.zzhtb[n];
        zzdza2.zzhtb[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdza zzdza2 = this;
        zzdza2.zzbao();
        zzdza2.zzfb(n);
        int n2 = zzdza2.zzhtb[n];
        if (n < zzdza2.size - 1) {
            System.arraycopy(zzdza2.zzhtb, n + 1, zzdza2.zzhtb, n, zzdza2.size - n - 1);
        }
        --zzdza2.size;
        ++zzdza2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdza zzdza2 = this;
        zzdza2.zzbao();
        if (n < 0 || n > zzdza2.size) {
            throw new IndexOutOfBoundsException(zzdza2.zzfc(n));
        }
        if (zzdza2.size < zzdza2.zzhtb.length) {
            System.arraycopy(zzdza2.zzhtb, n, zzdza2.zzhtb, n + 1, zzdza2.size - n);
        } else {
            int[] nArray = new int[zzdza2.size * 3 / 2 + 1];
            System.arraycopy(zzdza2.zzhtb, 0, nArray, 0, n);
            System.arraycopy(zzdza2.zzhtb, n, nArray, n + 1, zzdza2.size - n);
            zzdza2.zzhtb = nArray;
        }
        zzdza2.zzhtb[n] = n3;
        ++zzdza2.size;
        ++zzdza2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzgl(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzdzi zzfd(int n) {
        return this.zzgk(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzhta.zzban();
    }
}

