/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdxh;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdzi;
import com.google.android.gms.internal.ads.zzeat;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdzv
extends zzdxh<Long>
implements zzdzi<Long>,
zzeat,
RandomAccess {
    private static final zzdzv zzhut = new zzdzv(new long[0], 0);
    private long[] zzhuu;
    private int size;

    zzdzv() {
        this(new long[10], 0);
    }

    private zzdzv(long[] lArray, int n) {
        this.zzhuu = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbao();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhuu, n2, this.zzhuu, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdzv)) {
            return super.equals(object);
        }
        zzdzv zzdzv2 = (zzdzv)object;
        if (this.size != zzdzv2.size) {
            return false;
        }
        long[] lArray = zzdzv2.zzhuu;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhuu[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdzc.zzfr(this.zzhuu[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzfb(n);
        return this.zzhuu[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzfs(long l) {
        this.zzbao();
        if (this.size == this.zzhuu.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhuu, 0, lArray, 0, this.size);
            this.zzhuu = lArray;
        }
        this.zzhuu[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzbao();
        zzdzc.checkNotNull(collection);
        if (!(collection instanceof zzdzv)) {
            return super.addAll(collection);
        }
        zzdzv zzdzv2 = (zzdzv)collection;
        if (zzdzv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdzv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdzv2.size;
        if (n > this.zzhuu.length) {
            this.zzhuu = Arrays.copyOf(this.zzhuu, n);
        }
        System.arraycopy(zzdzv2.zzhuu, 0, this.zzhuu, this.size, zzdzv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbao();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhuu[i])) continue;
            System.arraycopy(this.zzhuu, i + 1, this.zzhuu, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfb(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfc(n));
        }
    }

    private final String zzfc(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdzv zzdzv2 = this;
        zzdzv2.zzbao();
        zzdzv2.zzfb(n);
        long l3 = zzdzv2.zzhuu[n];
        zzdzv2.zzhuu[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdzv zzdzv2 = this;
        zzdzv2.zzbao();
        zzdzv2.zzfb(n);
        long l = zzdzv2.zzhuu[n];
        if (n < zzdzv2.size - 1) {
            System.arraycopy(zzdzv2.zzhuu, n + 1, zzdzv2.zzhuu, n, zzdzv2.size - n - 1);
        }
        --zzdzv2.size;
        ++zzdzv2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdzv zzdzv2 = this;
        zzdzv2.zzbao();
        if (n < 0 || n > zzdzv2.size) {
            throw new IndexOutOfBoundsException(zzdzv2.zzfc(n));
        }
        if (zzdzv2.size < zzdzv2.zzhuu.length) {
            System.arraycopy(zzdzv2.zzhuu, n, zzdzv2.zzhuu, n + 1, zzdzv2.size - n);
        } else {
            long[] lArray = new long[zzdzv2.size * 3 / 2 + 1];
            System.arraycopy(zzdzv2.zzhuu, 0, lArray, 0, n);
            System.arraycopy(zzdzv2.zzhuu, n, lArray, n + 1, zzdzv2.size - n);
            zzdzv2.zzhuu = lArray;
        }
        zzdzv2.zzhuu[n] = l2;
        ++zzdzv2.size;
        ++zzdzv2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzfs(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzdzi zzfd(int n) {
        int n2 = n;
        zzdzv zzdzv2 = this;
        if (n2 < zzdzv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdzv(Arrays.copyOf(zzdzv2.zzhuu, n2), zzdzv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzhut.zzban();
    }
}

