/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaav;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzayx;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzui;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzut;
import com.google.android.gms.internal.ads.zzuv;
import com.google.android.gms.internal.ads.zzuz;
import com.google.android.gms.internal.ads.zzvg;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzvx;
import com.google.android.gms.internal.ads.zzxe;
import com.google.android.gms.internal.ads.zzxj;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzxs;
import com.google.android.gms.internal.ads.zzyx;
import com.google.android.gms.internal.ads.zzzc;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzxt {
    private final zzall zzbrk = new zzall();
    private final zzui zzabf;
    private final AtomicBoolean zzcfd;
    private final VideoController zzcfe = new VideoController();
    @VisibleForTesting
    private final zzvg zzcff = new zzxs(this);
    private zztz zzcch;
    private AdListener zzcck;
    private AdSize[] zzcdt;
    private AppEventListener zzbkr;
    private zzvx zzbrh;
    private OnCustomRenderedAdLoadedListener zzcfg;
    private VideoOptions zzbki;
    private String zzbri;
    private ViewGroup zzcfh;
    private int zzcfi;
    private boolean zzbkp;
    @Nullable
    private OnPaidEventListener zzcfj;

    public zzxt(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzui.zzcdb, 0);
    }

    public zzxt(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzui.zzcdb, n);
    }

    public zzxt(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzui.zzcdb, 0);
    }

    public zzxt(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzui.zzcdb, n);
    }

    @VisibleForTesting
    private zzxt(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzui zzui2, zzvx zzvx2, int n) {
        this.zzcfh = viewGroup;
        this.zzabf = zzui2;
        this.zzbrh = null;
        this.zzcfd = new AtomicBoolean(false);
        this.zzcfi = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzut zzut2 = new zzut(context, attributeSet);
                this.zzcdt = zzut2.zzy(bl);
                this.zzbri = zzut2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzvh.zzoz().zza(viewGroup, new zzuk(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzuk zzuk2;
                zzayx zzayx2 = zzvh.zzoz();
                int n2 = this.zzcfi;
                AdSize adSize = this.zzcdt[0];
                Context context2 = context;
                if (adSize.equals(AdSize.INVALID)) {
                    zzuk2 = zzuk.zzos();
                } else {
                    boolean bl2;
                    zzuk zzuk3 = new zzuk(context2, adSize);
                    new zzuk(context2, adSize).zzcdf = bl2 = zzxt.zzcm(n2);
                    zzuk2 = zzuk3;
                }
                zzayx2.zza(viewGroup, zzuk2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzxt(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzui zzui2, int n) {
        this(viewGroup, attributeSet, bl, zzui2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbrh != null) {
                this.zzbrh.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcck;
    }

    public final AdSize getAdSize() {
        try {
            zzuk zzuk2;
            if (this.zzbrh != null && (zzuk2 = this.zzbrh.zzke()) != null) {
                return zzuk2.zzot();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzcdt != null) {
            return this.zzcdt[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzcdt;
    }

    public final String getAdUnitId() {
        if (this.zzbri == null && this.zzbrh != null) {
            try {
                this.zzbri = this.zzbrh.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzazh.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzbri;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbkr;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcfg;
    }

    public final void zza(zzxr zzxr2) {
        try {
            if (this.zzbrh == null) {
                zzvx zzvx2;
                zzuk zzuk2;
                zzxt zzxt2 = this;
                if ((zzxt2.zzcdt == null || zzxt2.zzbri == null) && zzxt2.zzbrh == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzxt zzxt3 = zzxt2;
                Context context = zzxt3.zzcfh.getContext();
                Object object = zzuk2 = zzxt.zza(context, zzxt3.zzcdt, zzxt3.zzcfi);
                if ("search_v2".equals(object.zzabk)) {
                    String string = zzxt3.zzbri;
                    zzuk zzuk3 = zzuk2;
                    Context context2 = context;
                    object = zzvh.zzpa();
                    Context context3 = context2;
                    zzvx2 = (zzvx)new zzuz((zzus)object, context2, zzuk3, string).zzd(context3, false);
                } else {
                    zzall zzall2 = zzxt3.zzbrk;
                    String string = zzxt3.zzbri;
                    zzuk zzuk4 = zzuk2;
                    Context context4 = context;
                    object = zzvh.zzpa();
                    Context context5 = context4;
                    zzvx2 = (zzvx)new zzuv((zzus)object, context4, zzuk4, string, zzall2).zzd(context5, false);
                }
                zzxt2.zzbrh = zzvx2;
                zzxt2.zzbrh.zza(new zzud(zzxt2.zzcff));
                if (zzxt2.zzcch != null) {
                    zzxt2.zzbrh.zza(new zzty(zzxt2.zzcch));
                }
                if (zzxt2.zzbkr != null) {
                    zzxt2.zzbrh.zza(new zzuo(zzxt2.zzbkr));
                }
                if (zzxt2.zzcfg != null) {
                    zzxt2.zzbrh.zza(new zzaav(zzxt2.zzcfg));
                }
                if (zzxt2.zzbki != null) {
                    zzxt2.zzbrh.zza(new zzzc(zzxt2.zzbki));
                }
                zzxt2.zzbrh.zza(new zzyx(zzxt2.zzcfj));
                zzxt2.zzbrh.setManualImpressionsEnabled(zzxt2.zzbkp);
                zzxt zzxt4 = zzxt2;
                try {
                    IObjectWrapper iObjectWrapper = zzxt4.zzbrh.zzkc();
                    if (iObjectWrapper != null) {
                        zzxt4.zzcfh.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzazh.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzbrh.zza(zzui.zza(this.zzcfh.getContext(), zzxr2))) {
                this.zzbrk.zzf(zzxr2.zzps());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbrh != null) {
                this.zzbrh.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcfd.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbrh != null) {
                this.zzbrh.zzkd();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbrh != null) {
                this.zzbrh.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcck = adListener;
        this.zzcff.zza(adListener);
    }

    public final void zza(zztz zztz2) {
        try {
            this.zzcch = zztz2;
            if (this.zzbrh != null) {
                this.zzbrh.zza(zztz2 != null ? new zzty(zztz2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzcdt != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzcdt = adSizeArray;
        try {
            if (this.zzbrh != null) {
                this.zzbrh.zza(zzxt.zza(this.zzcfh.getContext(), this.zzcdt, this.zzcfi));
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzcfh.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzbri != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzbri = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbkr = appEventListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(appEventListener != null ? new zzuo(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcfg = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbrh != null) {
                this.zzbrh.zza(onCustomRenderedAdLoadedListener != null ? new zzaav(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbkp = bl;
        try {
            if (this.zzbrh != null) {
                this.zzbrh.setManualImpressionsEnabled(this.zzbkp);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbrh != null) {
                return this.zzbrh.zzkf();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbrh != null) {
                return this.zzbrh.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    @Nullable
    public final ResponseInfo getResponseInfo() {
        zzxe zzxe2 = null;
        try {
            if (this.zzbrh != null) {
                zzxe2 = this.zzbrh.zzkg();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        return ResponseInfo.zza(zzxe2);
    }

    public final void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        try {
            this.zzcfj = onPaidEventListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(new zzyx(onPaidEventListener));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final VideoController getVideoController() {
        return this.zzcfe;
    }

    public final zzxj zzdq() {
        if (this.zzbrh == null) {
            return null;
        }
        try {
            return this.zzbrh.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzbki = videoOptions;
        try {
            if (this.zzbrh != null) {
                this.zzbrh.zza(videoOptions == null ? null : new zzzc(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzbki;
    }

    public final boolean zza(zzvx zzvx2) {
        IObjectWrapper iObjectWrapper;
        if (zzvx2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzvx2.zzkc();
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzcfh.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzbrh = zzvx2;
        return true;
    }

    private static zzuk zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        Object object = adSizeArray;
        int n2 = adSizeArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!object[i].equals(AdSize.INVALID)) continue;
            return zzuk.zzos();
        }
        object = new zzuk(context, adSizeArray);
        new zzuk(context, adSizeArray).zzcdf = bl = zzxt.zzcm(n);
        return object;
    }

    private static boolean zzcm(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzxt zzxt2) {
        return zzxt2.zzcfe;
    }
}

