/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.appopen;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.appopen.AppOpenAdPresentationCallback;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzrd;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzvx;

public final class AppOpenAdView
extends ViewGroup {
    private AppOpenAd zzacg;
    private AppOpenAdPresentationCallback zzach;

    public AppOpenAdView(Context context) {
        super(context);
        Preconditions.checkNotNull((Object)context, (Object)"Context cannot be null");
    }

    public AppOpenAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public AppOpenAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public final void setAppOpenAd(AppOpenAd appOpenAd) {
        try {
            zzvx zzvx2 = appOpenAd.zzdr();
            if (zzvx2 == null) {
                return;
            }
            IObjectWrapper iObjectWrapper = zzvx2.zzkc();
            if (iObjectWrapper == null) {
                return;
            }
            View view = (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            if (view.getParent() == null) {
                this.removeAllViews();
                this.addView(view);
                this.zzacg = appOpenAd;
                this.zzds();
                return;
            }
            zzazh.zzey("Trying to set AppOpenAd which is already in use.");
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAppOpenAdPresentationCallback(AppOpenAdPresentationCallback appOpenAdPresentationCallback) {
        this.zzach = appOpenAdPresentationCallback;
        this.zzds();
    }

    private final void zzds() {
        if (this.zzacg != null && this.zzach != null) {
            this.zzacg.zza(new zzrd(this.zzach));
        }
    }

    private final AdSize getAdSize() {
        zzvx zzvx2 = this.zzacg.zzdr();
        try {
            zzuk zzuk2;
            if (zzvx2 != null && (zzuk2 = zzvx2.zzke()) != null) {
                return zzuk2.zzot();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzazh.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

