/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdxd;
import com.google.android.gms.internal.ads.zzdxk;
import com.google.android.gms.internal.ads.zzdxn;
import com.google.android.gms.internal.ads.zzdxo;
import com.google.android.gms.internal.ads.zzdyh;
import com.google.android.gms.internal.ads.zzdyj;
import com.google.android.gms.internal.ads.zzdzc;
import com.google.android.gms.internal.ads.zzdzq;
import com.google.android.gms.internal.ads.zzeah;
import com.google.android.gms.internal.ads.zzebd;
import com.google.android.gms.internal.ads.zzecb;
import com.google.android.gms.internal.ads.zzece;
import com.google.android.gms.internal.ads.zzech;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzdyi
extends zzdxo {
    private static final Logger logger = Logger.getLogger(zzdyi.class.getName());
    private static final boolean zzhpd = zzecb.zzbfi();
    zzdyj zzhpe;

    public static zzdyi zzv(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzb(byArray2, 0, n);
    }

    public static zzdyi zzm(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zza(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzecb.zzbfj()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzc(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzdyi() {
    }

    public abstract void zzab(int var1, int var2) throws IOException;

    public abstract void zzac(int var1, int var2) throws IOException;

    public abstract void zzad(int var1, int var2) throws IOException;

    public final void zzae(int n, int n2) throws IOException {
        this.zzad(n, zzdyi.zzgg(n2));
    }

    public abstract void zzaf(int var1, int var2) throws IOException;

    public abstract void zzh(int var1, long var2) throws IOException;

    public final void zzi(int n, long l) throws IOException {
        this.zzh(n, zzdyi.zzfp(l));
    }

    public abstract void zzj(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzaf(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzj(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzh(int var1, boolean var2) throws IOException;

    public abstract void zzf(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdxn var2) throws IOException;

    public abstract void zza(int var1, zzeah var2) throws IOException;

    abstract void zza(int var1, zzeah var2, zzebd var3) throws IOException;

    public abstract void zzb(int var1, zzeah var2) throws IOException;

    public abstract void zzb(int var1, zzdxn var2) throws IOException;

    public abstract void zzfv(int var1) throws IOException;

    public abstract void zzfw(int var1) throws IOException;

    public final void zzfx(int n) throws IOException {
        this.zzfw(zzdyi.zzgg(n));
    }

    public abstract void zzfy(int var1) throws IOException;

    public abstract void zzfh(long var1) throws IOException;

    public final void zzfi(long l) throws IOException {
        this.zzfh(zzdyi.zzfp(l));
    }

    public abstract void zzfj(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzfy(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzfj(Double.doubleToRawLongBits(d));
    }

    public final void zzbp(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzhj(String var1) throws IOException;

    public abstract void zzah(zzdxn var1) throws IOException;

    public abstract void zzg(zzeah var1) throws IOException;

    abstract void zza(zzeah var1, zzebd var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzag(int n, int n2) {
        return zzdyi.zzfz(n) + zzdyi.zzga(n2);
    }

    public static int zzah(int n, int n2) {
        return zzdyi.zzfz(n) + zzdyi.zzgb(n2);
    }

    public static int zzai(int n, int n2) {
        return zzdyi.zzfz(n) + zzdyi.zzgb(zzdyi.zzgg(n2));
    }

    public static int zzaj(int n, int n2) {
        return zzdyi.zzfz(n) + 4;
    }

    public static int zzak(int n, int n2) {
        return zzdyi.zzfz(n) + 4;
    }

    public static int zzk(int n, long l) {
        return zzdyi.zzfz(n) + zzdyi.zzfl(l);
    }

    public static int zzl(int n, long l) {
        return zzdyi.zzfz(n) + zzdyi.zzfl(l);
    }

    public static int zzm(int n, long l) {
        return zzdyi.zzfz(n) + zzdyi.zzfl(zzdyi.zzfp(l));
    }

    public static int zzn(int n, long l) {
        return zzdyi.zzfz(n) + 8;
    }

    public static int zzo(int n, long l) {
        return zzdyi.zzfz(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzdyi.zzfz(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzdyi.zzfz(n) + 8;
    }

    public static int zzi(int n, boolean bl) {
        return zzdyi.zzfz(n) + 1;
    }

    public static int zzal(int n, int n2) {
        return zzdyi.zzfz(n) + zzdyi.zzga(n2);
    }

    public static int zzg(int n, String string) {
        return zzdyi.zzfz(n) + zzdyi.zzhk(string);
    }

    public static int zzc(int n, zzdxn zzdxn2) {
        int n2 = zzdxn2.size();
        return zzdyi.zzfz(n) + (zzdyi.zzgb(n2) + n2);
    }

    public static int zza(int n, zzdzq zzdzq2) {
        int n2 = zzdzq2.zzbda();
        return zzdyi.zzfz(n) + (zzdyi.zzgb(n2) + n2);
    }

    public static int zzc(int n, zzeah zzeah2) {
        return zzdyi.zzfz(n) + zzdyi.zzh(zzeah2);
    }

    static int zzb(int n, zzeah zzeah2, zzebd zzebd2) {
        return zzdyi.zzfz(n) + zzdyi.zzb(zzeah2, zzebd2);
    }

    public static int zzd(int n, zzeah zzeah2) {
        return (zzdyi.zzfz(1) << 1) + zzdyi.zzah(2, n) + zzdyi.zzc(3, zzeah2);
    }

    public static int zzd(int n, zzdxn zzdxn2) {
        return (zzdyi.zzfz(1) << 1) + zzdyi.zzah(2, n) + zzdyi.zzc(3, zzdxn2);
    }

    public static int zzb(int n, zzdzq zzdzq2) {
        return (zzdyi.zzfz(1) << 1) + zzdyi.zzah(2, n) + zzdyi.zza(3, zzdzq2);
    }

    public static int zzfz(int n) {
        return zzdyi.zzgb(n << 3);
    }

    public static int zzga(int n) {
        if (n >= 0) {
            return zzdyi.zzgb(n);
        }
        return 10;
    }

    public static int zzgb(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzgc(int n) {
        return zzdyi.zzgb(zzdyi.zzgg(n));
    }

    public static int zzgd(int n) {
        return 4;
    }

    public static int zzge(int n) {
        return 4;
    }

    public static int zzfk(long l) {
        return zzdyi.zzfl(l);
    }

    public static int zzfl(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzfm(long l) {
        return zzdyi.zzfl(zzdyi.zzfp(l));
    }

    public static int zzfn(long l) {
        return 8;
    }

    public static int zzfo(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbq(boolean bl) {
        return 1;
    }

    public static int zzgf(int n) {
        return zzdyi.zzga(n);
    }

    public static int zzhk(String string) {
        int n;
        try {
            n = zzece.zza(string);
        }
        catch (zzech zzech2) {
            n = string.getBytes(zzdzc.UTF_8).length;
        }
        int n2 = n;
        return zzdyi.zzgb(n2) + n2;
    }

    public static int zza(zzdzq zzdzq2) {
        int n = zzdzq2.zzbda();
        return zzdyi.zzgb(n) + n;
    }

    public static int zzai(zzdxn zzdxn2) {
        int n = zzdxn2.size();
        return zzdyi.zzgb(n) + n;
    }

    public static int zzw(byte[] byArray) {
        int n = byArray.length;
        return zzdyi.zzgb(n) + n;
    }

    public static int zzh(zzeah zzeah2) {
        int n = zzeah2.zzbda();
        return zzdyi.zzgb(n) + n;
    }

    static int zzb(zzeah zzeah2, zzebd zzebd2) {
        zzebd zzebd3 = zzebd2;
        zzdxd zzdxd2 = (zzdxd)zzeah2;
        int n = zzdxd2.zzbaj();
        if (n == -1) {
            n = zzebd3.zzax(zzdxd2);
            zzdxd2.zzfa(n);
        }
        int n2 = n;
        return zzdyi.zzgb(n2) + n2;
    }

    private static int zzgg(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzfp(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzbcb();

    public final void zzbcc() {
        if (this.zzbcb() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzk(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzech zzech2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzech2);
        byte[] byArray = string.getBytes(zzdzc.UTF_8);
        try {
            this.zzfw(byArray.length);
            this.zzi(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzd(indexOutOfBoundsException);
        }
        catch (zzd zzd2) {
            throw zzd2;
        }
    }

    @Deprecated
    static int zzc(int n, zzeah zzeah2, zzebd zzebd2) {
        zzebd zzebd3;
        int n2 = zzdyi.zzfz(n) << 1;
        zzebd zzebd4 = zzebd3 = zzebd2;
        zzdxd zzdxd2 = (zzdxd)zzeah2;
        int n3 = zzdxd2.zzbaj();
        if (n3 == -1) {
            n3 = zzebd4.zzax(zzdxd2);
            zzdxd2.zzfa(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzi(zzeah zzeah2) {
        return zzeah2.zzbda();
    }

    @Deprecated
    public static int zzgh(int n) {
        return zzdyi.zzgb(n);
    }

    /* synthetic */ zzdyi(zzdyh zzdyh2) {
        this();
    }

    static final class zze
    extends zzdyi {
        private final ByteBuffer zzhph;
        private final ByteBuffer zzakt;
        private final long zzhpi;
        private final long zzhpj;
        private final long zzhpk;
        private final long zzhpl;
        private long zzana;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhph = byteBuffer;
            this.zzakt = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhpi = zzecb.zzn(byteBuffer);
            this.zzhpj = this.zzhpi + (long)byteBuffer.position();
            this.zzhpk = this.zzhpi + (long)byteBuffer.limit();
            this.zzhpl = this.zzhpk - 10L;
            this.zzana = this.zzhpj;
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdyi)this).zzfw(n << 3 | n3);
        }

        @Override
        public final void zzac(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfv(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfw(n2);
        }

        @Override
        public final void zzaf(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 5);
            ((zzdyi)this).zzfy(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfh(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 1);
            ((zzdyi)this).zzfj(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzhj(string);
        }

        @Override
        public final void zza(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzah(zzdxn2);
        }

        @Override
        public final void zza(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzg(zzeah2);
        }

        @Override
        final void zza(int n, zzeah zzeah2, zzebd zzebd2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zza(zzeah2, zzebd2);
        }

        @Override
        public final void zzb(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzeah2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzb(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzdxn2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzg(zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzfw(zzeah2.zzbda());
            zzeah2.zzb(this);
        }

        @Override
        final void zza(zzeah zzeah2, zzebd zzebd2) throws IOException {
            zzebd zzebd3 = zzebd2;
            zzdxd zzdxd2 = (zzdxd)zzeah2;
            int n = zzdxd2.zzbaj();
            if (n == -1) {
                n = zzebd3.zzax(zzdxd2);
                zzdxd2.zzfa(n);
            }
            ((zzdyi)this).zzfw(n);
            zzebd2.zza(zzeah2, this.zzhpe);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzana >= this.zzhpk) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzana, this.zzhpk, 1));
            }
            zzecb.zza(this.zzana++, by);
        }

        @Override
        public final void zzah(zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzfw(zzdxn2.size());
            zzdxn2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).zzfw(n2);
            ((zzdyi)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfv(int n) throws IOException {
            if (n >= 0) {
                ((zzdyi)this).zzfw(n);
                return;
            }
            ((zzdyi)this).zzfh(n);
        }

        @Override
        public final void zzfw(int n) throws IOException {
            if (this.zzana <= this.zzhpl) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzecb.zza(this.zzana++, (byte)n);
                        return;
                    }
                    zzecb.zza(this.zzana++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzana < this.zzhpk) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzecb.zza(this.zzana++, (byte)n);
                    return;
                }
                zzecb.zza(this.zzana++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzana, this.zzhpk, 1));
        }

        @Override
        public final void zzfy(int n) throws IOException {
            long l = this.zzana;
            zze zze2 = this;
            this.zzakt.putInt((int)(l - zze2.zzhpi), n);
            this.zzana += 4L;
        }

        @Override
        public final void zzfh(long l) throws IOException {
            if (this.zzana <= this.zzhpl) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzecb.zza(this.zzana++, (byte)l);
                        return;
                    }
                    zzecb.zza(this.zzana++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzana < this.zzhpk) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzecb.zza(this.zzana++, (byte)l);
                    return;
                }
                zzecb.zza(this.zzana++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzana, this.zzhpk, 1));
        }

        @Override
        public final void zzfj(long l) throws IOException {
            long l2 = this.zzana;
            zze zze2 = this;
            this.zzakt.putLong((int)(l2 - zze2.zzhpi), l);
            this.zzana += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhpk - (long)n2 < this.zzana) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzana, this.zzhpk, n2));
            }
            zzecb.zza(byArray, n, this.zzana, n2);
            this.zzana += (long)n2;
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhj(String string) throws IOException {
            long l = this.zzana;
            try {
                int n = zze.zzgb(string.length() * 3);
                int n2 = zze.zzgb(string.length());
                if (n2 == n) {
                    long l2 = this.zzana;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhpi) + n2;
                    this.zzakt.position(n3);
                    zzece.zza(string, this.zzakt);
                    int n4 = this.zzakt.position() - n3;
                    ((zzdyi)this).zzfw(n4);
                    this.zzana += (long)n4;
                    return;
                }
                int n5 = zzece.zza(string);
                ((zzdyi)this).zzfw(n5);
                this.zzfq(this.zzana);
                zzece.zza(string, this.zzakt);
                this.zzana += (long)n5;
                return;
            }
            catch (zzech zzech2) {
                this.zzana = l;
                this.zzfq(this.zzana);
                this.zza(string, zzech2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzana;
            zze zze2 = this;
            this.zzhph.position((int)(l - zze2.zzhpi));
        }

        @Override
        public final int zzbcb() {
            return (int)(this.zzhpk - this.zzana);
        }

        private final void zzfq(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzakt.position((int)(l2 - zze2.zzhpi));
        }
    }

    static final class zzc
    extends zzdyi {
        private final ByteBuffer zzhph;
        private final ByteBuffer zzakt;
        private final int zzhpg;

        zzc(ByteBuffer byteBuffer) {
            super(null);
            this.zzhph = byteBuffer;
            this.zzakt = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhpg = byteBuffer.position();
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdyi)this).zzfw(n << 3 | n3);
        }

        @Override
        public final void zzac(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfv(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfw(n2);
        }

        @Override
        public final void zzaf(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 5);
            ((zzdyi)this).zzfy(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfh(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 1);
            ((zzdyi)this).zzfj(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzhj(string);
        }

        @Override
        public final void zza(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzah(zzdxn2);
        }

        @Override
        public final void zza(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzg(zzeah2);
        }

        @Override
        final void zza(int n, zzeah zzeah2, zzebd zzebd2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zza(zzeah2, zzebd2);
        }

        @Override
        public final void zzb(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzeah2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzb(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzdxn2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzg(zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzfw(zzeah2.zzbda());
            zzeah2.zzb(this);
        }

        @Override
        final void zza(zzeah zzeah2, zzebd zzebd2) throws IOException {
            zzebd zzebd3 = zzebd2;
            zzdxd zzdxd2 = (zzdxd)zzeah2;
            int n = zzdxd2.zzbaj();
            if (n == -1) {
                n = zzebd3.zzax(zzdxd2);
                zzdxd2.zzfa(n);
            }
            ((zzdyi)this).zzfw(n);
            zzebd2.zza(zzeah2, this.zzhpe);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzakt.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzah(zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzfw(zzdxn2.size());
            zzdxn2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).zzfw(n2);
            ((zzdyi)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfv(int n) throws IOException {
            if (n >= 0) {
                ((zzdyi)this).zzfw(n);
                return;
            }
            ((zzdyi)this).zzfh(n);
        }

        @Override
        public final void zzfw(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzakt.put((byte)n);
                        return;
                    }
                    this.zzakt.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfy(int n) throws IOException {
            try {
                this.zzakt.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfh(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzakt.put((byte)l);
                        return;
                    }
                    this.zzakt.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfj(long l) throws IOException {
            try {
                this.zzakt.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzakt.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhj(String string) throws IOException {
            int n = this.zzakt.position();
            try {
                int n2 = zzc.zzgb(string.length() * 3);
                int n3 = zzc.zzgb(string.length());
                if (n3 == n2) {
                    int n4 = this.zzakt.position() + n3;
                    this.zzakt.position(n4);
                    this.zzhl(string);
                    int n5 = this.zzakt.position();
                    this.zzakt.position(n);
                    ((zzdyi)this).zzfw(n5 - n4);
                    this.zzakt.position(n5);
                    return;
                }
                int n6 = zzece.zza(string);
                ((zzdyi)this).zzfw(n6);
                this.zzhl(string);
                return;
            }
            catch (zzech zzech2) {
                this.zzakt.position(n);
                this.zza(string, zzech2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhph.position(this.zzakt.position());
        }

        @Override
        public final int zzbcb() {
            return this.zzakt.remaining();
        }

        private final void zzhl(String string) throws IOException {
            try {
                zzece.zza(string, this.zzakt);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }
    }

    static final class zza
    extends zzb {
        private final ByteBuffer zzhpf;
        private int zzhpg;

        zza(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhpf = byteBuffer;
            this.zzhpg = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhpf.position(this.zzhpg + this.zzbce());
        }
    }

    static class zzb
    extends zzdyi {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdyi)this).zzfw(n << 3 | n3);
        }

        @Override
        public final void zzac(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfv(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfw(n2);
        }

        @Override
        public final void zzaf(int n, int n2) throws IOException {
            ((zzdyi)this).zzab(n, 5);
            ((zzdyi)this).zzfy(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzfh(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdyi)this).zzab(n, 1);
            ((zzdyi)this).zzfj(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdyi)this).zzab(n, 0);
            ((zzdyi)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzhj(string);
        }

        @Override
        public final void zza(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzah(zzdxn2);
        }

        @Override
        public final void zzah(zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzfw(zzdxn2.size());
            zzdxn2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).zzfw(n2);
            ((zzdyi)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            ((zzdyi)this).zzg(zzeah2);
        }

        @Override
        final void zza(int n, zzeah zzeah2, zzebd zzebd2) throws IOException {
            ((zzdyi)this).zzab(n, 2);
            zzebd zzebd3 = zzebd2;
            zzdxd zzdxd2 = (zzdxd)zzeah2;
            int n2 = zzdxd2.zzbaj();
            if (n2 == -1) {
                n2 = zzebd3.zzax(zzdxd2);
                zzdxd2.zzfa(n2);
            }
            ((zzdyi)this).zzfw(n2);
            zzebd2.zza(zzeah2, this.zzhpe);
        }

        @Override
        public final void zzb(int n, zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzeah2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzb(int n, zzdxn zzdxn2) throws IOException {
            ((zzdyi)this).zzab(1, 3);
            ((zzdyi)this).zzad(2, n);
            ((zzdyi)this).zza(3, zzdxn2);
            ((zzdyi)this).zzab(1, 4);
        }

        @Override
        public final void zzg(zzeah zzeah2) throws IOException {
            ((zzdyi)this).zzfw(zzeah2.zzbda());
            zzeah2.zzb(this);
        }

        @Override
        final void zza(zzeah zzeah2, zzebd zzebd2) throws IOException {
            zzebd zzebd3 = zzebd2;
            zzdxd zzdxd2 = (zzdxd)zzeah2;
            int n = zzdxd2.zzbaj();
            if (n == -1) {
                n = zzebd3.zzax(zzdxd2);
                zzdxd2.zzfa(n);
            }
            ((zzdyi)this).zzfw(n);
            zzebd2.zza(zzeah2, this.zzhpe);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfv(int n) throws IOException {
            if (n >= 0) {
                ((zzdyi)this).zzfw(n);
                return;
            }
            ((zzdyi)this).zzfh(n);
        }

        @Override
        public final void zzfw(int n) throws IOException {
            if (zzhpd && !zzdxk.zzbap() && ((zzdyi)this).zzbcb() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzecb.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzecb.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzecb.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzecb.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzecb.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzecb.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzecb.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzecb.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zzecb.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfy(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfh(long l) throws IOException {
            if (zzhpd && ((zzdyi)this).zzbcb() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzecb.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzecb.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfj(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdyi)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhj(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzgb(string.length() * 3);
                int n3 = zzb.zzgb(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzece.zza(string, this.buffer, this.position, ((zzdyi)this).zzbcb());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzdyi)this).zzfw(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzece.zza(string);
                ((zzdyi)this).zzfw(n6);
                this.position = zzece.zza(string, this.buffer, this.position, ((zzdyi)this).zzbcb());
                return;
            }
            catch (zzech zzech2) {
                this.position = n;
                this.zza(string, zzech2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzbcb() {
            return this.limit - this.position;
        }

        public final int zzbce() {
            return this.position - this.offset;
        }
    }

    public static final class zzd
    extends IOException {
        zzd() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzd(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzd(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzd(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

