/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.AdMetadataListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaav;
import com.google.android.gms.internal.ads.zzall;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzue;
import com.google.android.gms.internal.ads.zzui;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzuy;
import com.google.android.gms.internal.ads.zzvh;
import com.google.android.gms.internal.ads.zzvx;
import com.google.android.gms.internal.ads.zzxe;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzyx;

public final class zzxv {
    private final zzall zzbrk = new zzall();
    private final Context zzur;
    private final zzui zzabf;
    private AdListener zzcck;
    private zztz zzcch;
    private zzvx zzbrh;
    private String zzbri;
    private AdMetadataListener zzccl;
    private AppEventListener zzbkr;
    private OnCustomRenderedAdLoadedListener zzcfg;
    private RewardedVideoAdListener zzcfp;
    private boolean zzcfq;
    private boolean zzblm;
    @Nullable
    private OnPaidEventListener zzcfj;

    public zzxv(Context context) {
        this(context, zzui.zzcdb, null);
    }

    public zzxv(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzui.zzcdb, publisherInterstitialAd);
    }

    @VisibleForTesting
    private zzxv(Context context, zzui zzui2, PublisherInterstitialAd publisherInterstitialAd) {
        this.zzur = context;
        this.zzabf = zzui2;
    }

    public final AdListener getAdListener() {
        return this.zzcck;
    }

    public final String getAdUnitId() {
        return this.zzbri;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbkr;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcfg;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbrh == null) {
                return false;
            }
            return this.zzbrh.isReady();
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbrh == null) {
                return false;
            }
            return this.zzbrh.isLoading();
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final void zza(zzxr zzxr2) {
        try {
            if (this.zzbrh == null) {
                String string = "loadAd";
                zzxv zzxv2 = this;
                if (zzxv2.zzbri == null) {
                    zzxv2.zzco(string);
                }
                zzuk zzuk2 = zzxv2.zzcfq ? zzuk.zzoq() : new zzuk();
                zzall zzall2 = zzxv2.zzbrk;
                String string2 = zzxv2.zzbri;
                zzuk zzuk3 = zzuk2;
                Context context = zzxv2.zzur;
                zzus zzus2 = zzvh.zzpa();
                Context context2 = context;
                zzxv2.zzbrh = (zzvx)new zzuy(zzus2, context, zzuk3, string2, zzall2).zzd(context2, false);
                if (zzxv2.zzcck != null) {
                    zzxv2.zzbrh.zza(new zzud(zzxv2.zzcck));
                }
                if (zzxv2.zzcch != null) {
                    zzxv2.zzbrh.zza(new zzty(zzxv2.zzcch));
                }
                if (zzxv2.zzccl != null) {
                    zzxv2.zzbrh.zza(new zzue(zzxv2.zzccl));
                }
                if (zzxv2.zzbkr != null) {
                    zzxv2.zzbrh.zza(new zzuo(zzxv2.zzbkr));
                }
                if (zzxv2.zzcfg != null) {
                    zzxv2.zzbrh.zza(new zzaav(zzxv2.zzcfg));
                }
                if (zzxv2.zzcfp != null) {
                    zzxv2.zzbrh.zza(new zzasi(zzxv2.zzcfp));
                }
                zzxv2.zzbrh.zza(new zzyx(zzxv2.zzcfj));
                zzxv2.zzbrh.setImmersiveMode(zzxv2.zzblm);
            }
            if (this.zzbrh.zza(zzui.zza(this.zzur, zzxr2))) {
                this.zzbrk.zzf(zzxr2.zzps());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzcck = adListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(adListener != null ? new zzud(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zza(zztz zztz2) {
        try {
            this.zzcch = zztz2;
            if (this.zzbrh != null) {
                this.zzbrh.zza(zztz2 != null ? new zzty(zztz2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzbri != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzbri = string;
    }

    public final void setAdMetadataListener(AdMetadataListener adMetadataListener) {
        try {
            this.zzccl = adMetadataListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(adMetadataListener != null ? new zzue(adMetadataListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final Bundle getAdMetadata() {
        try {
            if (this.zzbrh != null) {
                return this.zzbrh.getAdMetadata();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return new Bundle();
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbkr = appEventListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(appEventListener != null ? new zzuo(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzcfg = onCustomRenderedAdLoadedListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(onCustomRenderedAdLoadedListener != null ? new zzaav(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzcfp = rewardedVideoAdListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(rewardedVideoAdListener != null ? new zzasi(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zzd(boolean bl) {
        this.zzcfq = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbrh != null) {
                return this.zzbrh.zzkf();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return null;
    }

    public final ResponseInfo getResponseInfo() {
        zzxe zzxe2 = null;
        try {
            if (this.zzbrh != null) {
                zzxe2 = this.zzbrh.zzkg();
            }
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return ResponseInfo.zza(zzxe2);
    }

    public final void show() {
        try {
            this.zzco("show");
            this.zzbrh.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzblm = bl;
            if (this.zzbrh != null) {
                this.zzbrh.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        try {
            this.zzcfj = onPaidEventListener;
            if (this.zzbrh != null) {
                this.zzbrh.zza(new zzyx(onPaidEventListener));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazh.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    private final void zzco(String string) {
        if (this.zzbrh == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

