/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import com.google.android.gms.ads.zzc;
import com.google.android.gms.internal.ads.zzazw;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class RequestConfiguration {
    private final int zzacq;
    private final int zzacr;
    private final String zzacs;
    private final List<String> zzact;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final List<String> zzacu = Arrays.asList("MA", "T", "PG", "G");

    private RequestConfiguration(int n, int n2, String string, List<String> list) {
        this.zzacq = n;
        this.zzacr = n2;
        this.zzacs = string;
        this.zzact = list;
    }

    public int getTagForChildDirectedTreatment() {
        return this.zzacq;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzacr;
    }

    public String getMaxAdContentRating() {
        if (this.zzacs == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return this.zzacs;
    }

    public List<String> getTestDeviceIds() {
        return new ArrayList<String>(this.zzact);
    }

    public Builder toBuilder() {
        return new Builder().setTagForChildDirectedTreatment(this.zzacq).setTagForUnderAgeOfConsent(this.zzacr).setMaxAdContentRating(this.zzacs).setTestDeviceIds(this.zzact);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, List list, zzc zzc2) {
        this(n, n2, string, list);
    }

    public static class Builder {
        private int zzacq = -1;
        private int zzacr = -1;
        private String zzacs = null;
        private final List<String> zzact = new ArrayList<String>();

        public RequestConfiguration build() {
            return new RequestConfiguration(this.zzacq, this.zzacr, this.zzacs, this.zzact, null);
        }

        public Builder setTagForChildDirectedTreatment(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzacq = n;
            } else {
                zzazw.zzfc(new StringBuilder(68).append("Invalid value passed to setTagForChildDirectedTreatment: ").append(n).toString());
            }
            return this;
        }

        public Builder setTagForUnderAgeOfConsent(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzacr = n;
            } else {
                zzazw.zzfc(new StringBuilder(63).append("Invalid value passed to setTagForUnderAgeOfConsent: ").append(n).toString());
            }
            return this;
        }

        public Builder setMaxAdContentRating(String string) {
            if (string == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(string)) {
                this.zzacs = null;
            } else if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(string)) {
                this.zzacs = string;
            } else {
                String string2 = String.valueOf(string);
                zzazw.zzfc(string2.length() != 0 ? "Invalid value passed to setMaxAdContentRating: ".concat(string2) : new String("Invalid value passed to setMaxAdContentRating: "));
            }
            return this;
        }

        public Builder setTestDeviceIds(@Nullable List<String> list) {
            this.zzact.clear();
            if (list != null) {
                this.zzact.addAll(list);
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

