/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzzf;
import javax.annotation.concurrent.GuardedBy;

public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    @Nullable
    private zzxl zzacw;
    @GuardedBy(value="lock")
    @Nullable
    private VideoLifecycleCallbacks zzacx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzxl zzxl2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzacw = zzxl2;
            if (this.zzacx != null) {
                this.setVideoLifecycleCallbacks(this.zzacx);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzxl zzdu() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzacw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return;
            }
            try {
                this.zzacw.play();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return;
            }
            try {
                this.zzacw.pause();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return;
            }
            try {
                this.zzacw.stop();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call stop on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mute(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return;
            }
            try {
                this.zzacw.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMuted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return true;
            }
            try {
                return this.zzacw.isMuted();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return 0;
            }
            try {
                return this.zzacw.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCustomControlsEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return false;
            }
            try {
                return this.zzacw.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClickToExpandEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return false;
            }
            try {
                return this.zzacw.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getVideoDuration() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return 0.0f;
            }
            try {
                return this.zzacw.getDuration();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call getDuration on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getVideoCurrentTime() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return 0.0f;
            }
            try {
                return this.zzacw.getCurrentTime();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call getCurrentTime on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        Preconditions.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.lock;
        synchronized (object) {
            this.zzacx = videoLifecycleCallbacks;
            if (this.zzacw == null) {
                return;
            }
            try {
                this.zzacw.zza(new zzzf(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzacx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzacw != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final float getAspectRatio() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzacw == null) {
                return 0.0f;
            }
            try {
                return this.zzacw.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

