/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzxs;
import com.google.android.gms.internal.ads.zzxt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzxt zzacc;

    private PublisherAdRequest(Builder builder) {
        this.zzacc = new zzxt(builder.zzacd);
    }

    @Deprecated
    public final Date getBirthday() {
        return this.zzacc.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzacc.getContentUrl();
    }

    @Deprecated
    public final int getGender() {
        return this.zzacc.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzacc.getKeywords();
    }

    public final Location getLocation() {
        return this.zzacc.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzacc.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzacc.getNetworkExtras(clazz);
    }

    public final <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzacc.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzacc.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzacc.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzacc.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzacc.getCustomTargeting();
    }

    @Deprecated
    @KeepForSdk
    public static void updateCorrelator() {
    }

    public final zzxt zzdq() {
        return this.zzacc;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzxs zzacd = new zzxs();

        public final Builder addKeyword(String string) {
            this.zzacd.zzch(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzacd.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationExtrasReceiver> clazz, Bundle bundle) {
            this.zzacd.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzacd.zzb(clazz, bundle);
            return this;
        }

        @Deprecated
        public final Builder addTestDevice(String string) {
            this.zzacd.zzci(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        @Deprecated
        public final Builder setBirthday(Date date) {
            this.zzacd.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzacd.zzck(string);
            return this;
        }

        @Deprecated
        public final Builder setGender(int n) {
            this.zzacd.zzct(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzacd.zza(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzacd.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzacd.zzcl(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzacd.zzcm(string);
            return this;
        }

        @Deprecated
        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzacd.zzz(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzacd.zze(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzacd.zze(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzacd.zzcn(string);
            return this;
        }

        @KeepForSdk
        public final Builder setAdInfo(AdInfo adInfo) {
            this.zzacd.zza(adInfo);
            return this;
        }

        @Deprecated
        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzacd.zzaa(bl);
            return this;
        }

        @Deprecated
        public final Builder setTagForUnderAgeOfConsent(int n) {
            this.zzacd.zzcu(n);
            return this;
        }

        @Deprecated
        public final Builder setMaxAdContentRating(String string) {
            this.zzacd.zzco(string);
            return this;
        }
    }
}

