/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.zzd;
import com.google.android.gms.ads.formats.zze;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacr;
import com.google.android.gms.internal.ads.zzacw;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzyg;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;

public final class UnifiedNativeAdView
extends FrameLayout {
    private final FrameLayout zzbld;
    private final zzacw zzble;

    public UnifiedNativeAdView(Context context) {
        super(context);
        this.zzbld = this.zzd(context);
        this.zzble = this.zzjs();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbld = this.zzd(context);
        this.zzble = this.zzjs();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbld = this.zzd(context);
        this.zzble = this.zzjs();
    }

    @TargetApi(value=21)
    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzbld = this.zzd(context);
        this.zzble = this.zzjs();
    }

    private final void zza(String string, View view) {
        try {
            this.zzble.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    public final void setHeadlineView(View view) {
        this.zza("3001", view);
    }

    public final void setCallToActionView(View view) {
        this.zza("3002", view);
    }

    public final void setIconView(View view) {
        this.zza("3003", view);
    }

    public final void setBodyView(View view) {
        this.zza("3004", view);
    }

    public final void setAdvertiserView(View view) {
        this.zza("3005", view);
    }

    public final void setStoreView(View view) {
        this.zza("3006", view);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzble.zze(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(View view) {
        this.zza("3007", view);
    }

    public final void setImageView(View view) {
        this.zza("3008", view);
    }

    public final void setStarRatingView(View view) {
        this.zza("3009", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zza("3010", (View)mediaView);
        if (mediaView != null) {
            mediaView.zza(new zze(this));
            mediaView.zza(new zzd(this));
        }
    }

    public final void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("3011", (View)adChoicesView);
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        try {
            this.zzble.zza((IObjectWrapper)unifiedNativeAd.zzjq());
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    private final View zzbl(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzble.zzcq(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public final View getHeadlineView() {
        return this.zzbl("3001");
    }

    public final View getCallToActionView() {
        return this.zzbl("3002");
    }

    public final View getIconView() {
        return this.zzbl("3003");
    }

    public final View getBodyView() {
        return this.zzbl("3004");
    }

    public final View getStoreView() {
        return this.zzbl("3006");
    }

    public final View getPriceView() {
        return this.zzbl("3007");
    }

    public final View getAdvertiserView() {
        return this.zzbl("3005");
    }

    public final View getImageView() {
        return this.zzbl("3008");
    }

    public final View getStarRatingView() {
        return this.zzbl("3009");
    }

    public final MediaView getMediaView() {
        View view = this.zzbl("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzazw.zzed("View is not an instance of MediaView");
        }
        return null;
    }

    public final AdChoicesView getAdChoicesView() {
        View view = this.zzbl("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final void destroy() {
        try {
            this.zzble.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzd(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzacw zzjs() {
        Preconditions.checkNotNull((Object)this.zzbld, (Object)"createDelegate must be called after overlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzvj.zzps().zza(this.zzbld.getContext(), this, this.zzbld);
    }

    public final void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzbld);
    }

    public final void removeView(View view) {
        if (this.zzbld == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzbld);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzbld != view) {
            super.bringChildToFront((View)this.zzbld);
        }
    }

    public final void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzble != null) {
            try {
                this.zzble.zzc(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }

    public final boolean dispatchTouchEvent(MotionEvent motionEvent) {
        zzzk<Boolean> zzzk2 = zzzz.zzcoj;
        if (zzvj.zzpv().zzd(zzzk2).booleanValue() && this.zzble != null) {
            try {
                this.zzble.zzf(ObjectWrapper.wrap((Object)motionEvent));
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call handleTouchEvent on delegate", remoteException);
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    final /* synthetic */ void zza(ImageView.ScaleType scaleType) {
        try {
            if (scaleType != null) {
                this.zzble.zzg(ObjectWrapper.wrap((Object)scaleType));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    final /* synthetic */ void zza(MediaContent mediaContent) {
        try {
            if (mediaContent instanceof zzyg) {
                this.zzble.zza(((zzyg)mediaContent).zzqr());
                return;
            }
            if (mediaContent == null) {
                this.zzble.zza((zzacr)null);
                return;
            }
            zzazw.zzed("Use MediaContent provided by UnifiedNativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }
}

