/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzean;
import com.google.android.gms.internal.ads.zzear;
import com.google.android.gms.internal.ads.zzeas;
import com.google.android.gms.internal.ads.zzeat;
import com.google.android.gms.internal.ads.zzeau;
import com.google.android.gms.internal.ads.zzeaw;
import com.google.android.gms.internal.ads.zzeay;
import com.google.android.gms.internal.ads.zzeaz;
import com.google.android.gms.internal.ads.zzeba;
import com.google.android.gms.internal.ads.zzebc;
import com.google.android.gms.internal.ads.zzebd;
import com.google.android.gms.internal.ads.zzebf;
import com.google.android.gms.internal.ads.zzecg;
import com.google.android.gms.internal.ads.zzeed;
import com.google.android.gms.internal.ads.zzeey;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;

public abstract class zzeaq
implements Serializable,
Iterable<Byte> {
    public static final zzeaq zzhtf = new zzeba(zzecg.zzhtn);
    private static final zzeaw zzhtg = zzean.zzbcl() ? new zzebc(null) : new zzeau(null);
    private int zzhsp = 0;
    private static final Comparator<zzeaq> zzhth = new zzeas();

    zzeaq() {
    }

    public abstract byte zzfo(int var1);

    abstract byte zzfp(int var1);

    public zzeaz zzbcn() {
        return new zzeat(this);
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private static int zzb(byte by) {
        return by & 0xFF;
    }

    public abstract zzeaq zzz(int var1, int var2);

    public static zzeaq zzh(byte[] byArray, int n, int n2) {
        zzeaq.zzi(n, n + n2, byArray.length);
        return new zzeba(zzhtg.zzj(byArray, n, n2));
    }

    public static zzeaq zzu(byte[] byArray) {
        return zzeaq.zzh(byArray, 0, byArray.length);
    }

    static zzeaq zzv(byte[] byArray) {
        return new zzeba(byArray);
    }

    public static zzeaq zzhq(String string) {
        return new zzeba(string.getBytes(zzecg.UTF_8));
    }

    public static zzeaq zzf(InputStream inputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        ArrayList<zzeaq> arrayList = new ArrayList<zzeaq>();
        int n = 256;
        while (true) {
            int n2;
            int n3;
            int n4 = n;
            InputStream inputStream3 = inputStream2;
            byte[] byArray = new byte[n4];
            for (n2 = 0; n2 < n4 && (n3 = inputStream3.read(byArray, n2, n4 - n2)) != -1; n2 += n3) {
            }
            zzeaq zzeaq2 = n2 == 0 ? null : zzeaq.zzh(byArray, 0, n2);
            if (zzeaq2 == null) break;
            arrayList.add(zzeaq2);
            n = Math.min(n << 1, 8192);
        }
        return zzeaq.zzl(arrayList);
    }

    public static zzeaq zzl(Iterable<zzeaq> iterable) {
        int n;
        if (!(iterable instanceof Collection)) {
            int n2 = 0;
            Iterator<zzeaq> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n2;
            }
            n = n2;
        } else {
            n = ((Collection)iterable).size();
        }
        if (n == 0) {
            return zzhtf;
        }
        return zzeaq.zza(iterable.iterator(), n);
    }

    private static zzeaq zza(Iterator<zzeaq> iterator, int n) {
        zzeaq zzeaq2;
        if (n <= 0) {
            throw new IllegalArgumentException(String.format("length (%s) must be >= 1", n));
        }
        if (n == 1) {
            zzeaq2 = iterator.next();
        } else {
            zzeaq zzeaq3;
            int n2 = n >>> 1;
            zzeaq zzeaq4 = zzeaq.zza(iterator, n2);
            zzeaq zzeaq5 = zzeaq3 = zzeaq.zza(iterator, n - n2);
            zzeaq zzeaq6 = zzeaq4;
            if (Integer.MAX_VALUE - zzeaq6.size() < zzeaq5.size()) {
                int n3 = zzeaq6.size();
                int n4 = zzeaq5.size();
                throw new IllegalArgumentException(new StringBuilder(53).append("ByteString would be too long: ").append(n3).append("+").append(n4).toString());
            }
            zzeaq2 = zzeed.zza(zzeaq6, zzeaq5);
        }
        return zzeaq2;
    }

    @Deprecated
    public final void zza(byte[] byArray, int n, int n2, int n3) {
        zzeaq.zzi(n, n + n3, this.size());
        zzeaq.zzi(n2, n2 + n3, byArray.length);
        if (n3 > 0) {
            this.zzb(byArray, n, n2, n3);
        }
    }

    protected abstract void zzb(byte[] var1, int var2, int var3, int var4);

    public final byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return zzecg.zzhtn;
        }
        byte[] byArray = new byte[n];
        this.zzb(byArray, 0, 0, n);
        return byArray;
    }

    abstract void zza(zzear var1) throws IOException;

    protected abstract String zza(Charset var1);

    public final String zzbco() {
        Charset charset = zzecg.UTF_8;
        zzeaq zzeaq2 = this;
        if (zzeaq2.size() == 0) {
            return "";
        }
        return zzeaq2.zza(charset);
    }

    public abstract boolean zzbcp();

    protected abstract int zzg(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n = this.zzhsp;
        if (n == 0) {
            int n2 = this.size();
            n = this.zzh(n2, 0, n2);
            if (n == 0) {
                n = 1;
            }
            this.zzhsp = n;
        }
        return n;
    }

    public abstract zzebf zzbcq();

    public static zzebd zzbcr() {
        return new zzebd(128);
    }

    static zzeay zzfq(int n) {
        return new zzeay(n, null);
    }

    protected abstract int zzbcs();

    protected abstract boolean zzbct();

    protected final int zzbcu() {
        return this.zzhsp;
    }

    protected abstract int zzh(int var1, int var2, int var3);

    static void zzaa(int n, int n2) {
        if ((n | n2 - (n + 1)) < 0) {
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(22).append("Index < 0: ").append(n).toString());
            }
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(40).append("Index > length: ").append(n).append(", ").append(n2).toString());
        }
    }

    static int zzi(int n, int n2, int n3) {
        int n4 = n2 - n;
        if ((n | n2 | n4 | n3 - n2) < 0) {
            if (n < 0) {
                throw new IndexOutOfBoundsException(new StringBuilder(32).append("Beginning index: ").append(n).append(" < 0").toString());
            }
            if (n2 < n) {
                throw new IndexOutOfBoundsException(new StringBuilder(66).append("Beginning index larger than ending index: ").append(n).append(", ").append(n2).toString());
            }
            throw new IndexOutOfBoundsException(new StringBuilder(37).append("End index: ").append(n2).append(" >= ").append(n3).toString());
        }
        return n4;
    }

    public final String toString() {
        zzeaq zzeaq2;
        return String.format(Locale.ROOT, "<ByteString@%s size=%d contents=\"%s\">", Integer.toHexString(System.identityHashCode(this)), this.size(), (zzeaq2 = this).size() <= 50 ? zzeey.zzam(zzeaq2) : String.valueOf(zzeey.zzam(zzeaq2.zzz(0, 47))).concat("..."));
    }

    @Override
    public /* synthetic */ Iterator iterator() {
        return this.zzbcn();
    }

    static /* synthetic */ int zzc(byte by) {
        return zzeaq.zzb(by);
    }
}

