/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzeak;
import com.google.android.gms.internal.ads.zzecg;
import com.google.android.gms.internal.ads.zzecl;
import com.google.android.gms.internal.ads.zzeea;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzebp
extends zzeak<Double>
implements zzecl<Double>,
zzeea,
RandomAccess {
    private static final zzebp zzhul = new zzebp(new double[0], 0);
    private double[] zzhum;
    private int size;

    zzebp() {
        this(new double[10], 0);
    }

    private zzebp(double[] dArray, int n) {
        this.zzhum = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhum, n2, this.zzhum, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzebp)) {
            return super.equals(object);
        }
        zzebp zzebp2 = (zzebp)object;
        if (this.size != zzebp2.size) {
            return false;
        }
        double[] dArray = zzebp2.zzhum;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhum[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhum[i]);
            n = n * 31 + zzecg.zzfr(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzbck();
        if (this.size == this.zzhum.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhum, 0, dArray, 0, this.size);
            this.zzhum = dArray;
        }
        this.zzhum[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzbck();
        zzecg.checkNotNull(collection);
        if (!(collection instanceof zzebp)) {
            return super.addAll(collection);
        }
        zzebp zzebp2 = (zzebp)collection;
        if (zzebp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzebp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzebp2.size;
        if (n > this.zzhum.length) {
            this.zzhum = Arrays.copyOf(this.zzhum, n);
        }
        System.arraycopy(zzebp2.zzhum, 0, this.zzhum, this.size, zzebp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhum[i])) continue;
            System.arraycopy(this.zzhum, i + 1, this.zzhum, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfl(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfm(n));
        }
    }

    private final String zzfm(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzebp zzebp2 = this;
        zzebp2.zzbck();
        zzebp2.zzfl(n);
        double d3 = zzebp2.zzhum[n];
        zzebp2.zzhum[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzebp zzebp2 = this;
        zzebp2.zzbck();
        zzebp2.zzfl(n);
        double d = zzebp2.zzhum[n];
        if (n < zzebp2.size - 1) {
            System.arraycopy(zzebp2.zzhum, n + 1, zzebp2.zzhum, n, zzebp2.size - n - 1);
        }
        --zzebp2.size;
        ++zzebp2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzebp zzebp2 = this;
        zzebp2.zzbck();
        if (n < 0 || n > zzebp2.size) {
            throw new IndexOutOfBoundsException(zzebp2.zzfm(n));
        }
        if (zzebp2.size < zzebp2.zzhum.length) {
            System.arraycopy(zzebp2.zzhum, n, zzebp2.zzhum, n + 1, zzebp2.size - n);
        } else {
            double[] dArray = new double[zzebp2.size * 3 / 2 + 1];
            System.arraycopy(zzebp2.zzhum, 0, dArray, 0, n);
            System.arraycopy(zzebp2.zzhum, n, dArray, n + 1, zzebp2.size - n);
            zzebp2.zzhum = dArray;
        }
        zzebp2.zzhum[n] = d2;
        ++zzebp2.size;
        ++zzebp2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzd(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzecl zzfn(int n) {
        int n2 = n;
        zzebp zzebp2 = this;
        if (n2 < zzebp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzebp(Arrays.copyOf(zzebp2.zzhum, n2), zzebp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzebp zzebp2 = this;
        zzebp2.zzfl(n);
        return zzebp2.zzhum[n];
    }

    static {
        zzhul.zzbcj();
    }
}

