/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzeak;
import com.google.android.gms.internal.ads.zzecg;
import com.google.android.gms.internal.ads.zzecl;
import com.google.android.gms.internal.ads.zzecm;
import com.google.android.gms.internal.ads.zzeea;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzedc
extends zzeak<Long>
implements zzecm,
zzeea,
RandomAccess {
    private static final zzedc zzhzt = new zzedc(new long[0], 0);
    private long[] zzhzu;
    private int size;

    public static zzedc zzbfx() {
        return zzhzt;
    }

    zzedc() {
        this(new long[10], 0);
    }

    private zzedc(long[] lArray, int n) {
        this.zzhzu = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhzu, n2, this.zzhzu, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzedc)) {
            return super.equals(object);
        }
        zzedc zzedc2 = (zzedc)object;
        if (this.size != zzedc2.size) {
            return false;
        }
        long[] lArray = zzedc2.zzhzu;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhzu[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzecg.zzfr(this.zzhzu[i]);
        }
        return n;
    }

    @Override
    public final zzecm zzgx(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzedc(Arrays.copyOf(this.zzhzu, n), this.size);
    }

    public final long getLong(int n) {
        this.zzfl(n);
        return this.zzhzu[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzfs(long l) {
        this.zzbck();
        if (this.size == this.zzhzu.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhzu, 0, lArray, 0, this.size);
            this.zzhzu = lArray;
        }
        this.zzhzu[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzbck();
        zzecg.checkNotNull(collection);
        if (!(collection instanceof zzedc)) {
            return super.addAll(collection);
        }
        zzedc zzedc2 = (zzedc)collection;
        if (zzedc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzedc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzedc2.size;
        if (n > this.zzhzu.length) {
            this.zzhzu = Arrays.copyOf(this.zzhzu, n);
        }
        System.arraycopy(zzedc2.zzhzu, 0, this.zzhzu, this.size, zzedc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhzu[i])) continue;
            System.arraycopy(this.zzhzu, i + 1, this.zzhzu, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfl(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfm(n));
        }
    }

    private final String zzfm(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzedc zzedc2 = this;
        zzedc2.zzbck();
        zzedc2.zzfl(n);
        long l3 = zzedc2.zzhzu[n];
        zzedc2.zzhzu[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzedc zzedc2 = this;
        zzedc2.zzbck();
        zzedc2.zzfl(n);
        long l = zzedc2.zzhzu[n];
        if (n < zzedc2.size - 1) {
            System.arraycopy(zzedc2.zzhzu, n + 1, zzedc2.zzhzu, n, zzedc2.size - n - 1);
        }
        --zzedc2.size;
        ++zzedc2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzedc zzedc2 = this;
        zzedc2.zzbck();
        if (n < 0 || n > zzedc2.size) {
            throw new IndexOutOfBoundsException(zzedc2.zzfm(n));
        }
        if (zzedc2.size < zzedc2.zzhzu.length) {
            System.arraycopy(zzedc2.zzhzu, n, zzedc2.zzhzu, n + 1, zzedc2.size - n);
        } else {
            long[] lArray = new long[zzedc2.size * 3 / 2 + 1];
            System.arraycopy(zzedc2.zzhzu, 0, lArray, 0, n);
            System.arraycopy(zzedc2.zzhzu, n, lArray, n + 1, zzedc2.size - n);
            zzedc2.zzhzu = lArray;
        }
        zzedc2.zzhzu[n] = l2;
        ++zzedc2.size;
        ++zzedc2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzfs(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzecl zzfn(int n) {
        return this.zzgx(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzhzt.zzbcj();
    }
}

