/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzvj;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zzum
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzum> CREATOR = new zzup();
    @SafeParcelable.Field(id=2)
    public final String zzacf;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzcew;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zzum[] zzcex;
    @SafeParcelable.Field(id=9)
    public final boolean zzbnf;
    @SafeParcelable.Field(id=10)
    public final boolean zzcey;
    @SafeParcelable.Field(id=11)
    public boolean zzcez;
    @SafeParcelable.Field(id=12)
    public boolean zzcfa;
    @SafeParcelable.Field(id=13)
    private boolean zzcfb;
    @SafeParcelable.Field(id=14)
    public boolean zzcfc;
    @SafeParcelable.Field(id=15)
    public boolean zzcfd;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zzum.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzum zzph() {
        return new zzum("320x50_mb", 0, 0, false, 0, 0, null, true, false, false, false, false, false, false);
    }

    public static zzum zzpi() {
        return new zzum("reward_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false);
    }

    public static zzum zzpj() {
        return new zzum("interstitial_mb", 0, 0, false, 0, 0, null, false, false, false, false, true, false, false);
    }

    public zzum() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false, false);
    }

    public static zzum zzpk() {
        return new zzum("invalid", 0, 0, false, 0, 0, null, false, false, false, true, false, false, false);
    }

    public zzum(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zzum(Context var1_1, AdSize[] var2_2) {
        block15: {
            block14: {
                super();
                var3_3 = var2_2[0];
                this.zzcew = false;
                this.zzcey = var3_3.isFluid();
                this.zzcfc = zzb.zza(var3_3);
                this.zzcfd = zzb.zzb(var3_3);
                if (this.zzcey) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else if (this.zzcfd) {
                    this.width = var3_3.getWidth();
                    this.height = zzb.zzc(var3_3);
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block14;
                zzvj.zzpr();
                if (!zzazm.zzbn(var1_1)) ** GOTO lbl-1000
                zzvj.zzpr();
                if (zzazm.zzbo(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzvj.zzpr();
                    this.widthPixels = v0 - zzazm.zzbp(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_11 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_11;
                }
                break block15;
            }
            var7_11 = this.width;
            zzvj.zzpr();
            this.widthPixels = zzazm.zza(var6_6, this.width);
        }
        var8_12 = var5_5 != false ? zzum.zzd(var6_6) : this.height;
        zzvj.zzpr();
        this.heightPixels = zzazm.zza(var6_6, var8_12);
        if (var4_4 || var5_5) {
            var9_8 = var7_11;
            this.zzacf = new StringBuilder(26).append(var9_8).append("x").append(var8_12).append("_as").toString();
        } else if (this.zzcfd) {
            var9_9 = this.width;
            var10_13 = this.height;
            this.zzacf = new StringBuilder(26).append(var9_9).append("x").append(var10_13).append("_as").toString();
        } else {
            this.zzacf = this.zzcey != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzcex = new zzum[var2_2.length];
            for (var9_10 = 0; var9_10 < var2_2.length; ++var9_10) {
                this.zzcex[var9_10] = new zzum(var1_1, var2_2[var9_10]);
            }
        } else {
            this.zzcex = null;
        }
        this.zzbnf = false;
        this.zzcez = false;
    }

    @SafeParcelable.Constructor
    zzum(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzum[] zzumArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) boolean bl8) {
        this.zzacf = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzcew = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzcex = zzumArray;
        this.zzbnf = bl2;
        this.zzcey = bl3;
        this.zzcez = bl4;
        this.zzcfa = bl5;
        this.zzcfb = bl6;
        this.zzcfc = bl7;
        this.zzcfd = bl8;
    }

    public final AdSize zzpl() {
        return zzb.zza(this.width, this.height, this.zzacf);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzum zzum2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzum2.zzacf, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzum2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzum2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zzum2.zzcew);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zzum2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzum2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zzum2.zzcex, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzum2.zzbnf);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzum2.zzcey);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzum2.zzcez);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)12, (boolean)zzum2.zzcfa);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)13, (boolean)zzum2.zzcfb);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)14, (boolean)zzum2.zzcfc);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)15, (boolean)zzum2.zzcfd);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

