/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzxl;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzbgz {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzlw;
    private InterstitialAd zzlx;
    private AdLoader zzly;
    private Context zzlz;
    private InterstitialAd zzma;
    private MediationRewardedVideoAdListener zzmb;
    @VisibleForTesting
    private final RewardedVideoAdListener zzmc = new com.google.ads.mediation.zzb(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzvj.zzpr();
            builder.addTestDevice(zzazm.zzbk(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzlw != null) {
            this.zzlw.destroy();
            this.zzlw = null;
        }
        if (this.zzlx != null) {
            this.zzlx = null;
        }
        if (this.zzly != null) {
            this.zzly = null;
        }
        if (this.zzma != null) {
            this.zzma = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzlw != null) {
            this.zzlw.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzlw != null) {
            this.zzlw.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzlw = new AdView(context);
        this.zzlw.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzlw.setAdUnitId(this.getAdUnitId(bundle));
        this.zzlw.setAdListener(new zzc(this, mediationBannerListener));
        this.zzlw.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzlw;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzlx = new InterstitialAd(context);
        this.zzlx.setAdUnitId(this.getAdUnitId(bundle));
        this.zzlx.setAdListener(new zzf(this, mediationInterstitialListener));
        this.zzlx.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzlx != null) {
            this.zzlx.setImmersiveMode(bl);
        }
        if (this.zzma != null) {
            this.zzma.setImmersiveMode(bl);
        }
    }

    @Override
    public zzxl getVideoController() {
        VideoController videoController;
        if (this.zzlw != null && (videoController = this.zzlw.getVideoController()) != null) {
            return videoController.zzdu();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzlx.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzdo(1).zzact();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isUnifiedNativeAdRequested()) {
            builder.forUnifiedNativeAd(zze2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zztw()) {
            for (String string2 : nativeMediationAdRequest.zztx().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zztx().get(string2) != false ? zze2 : null);
            }
        }
        this.zzly = builder.build();
        this.zzly.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzlz = context.getApplicationContext();
        this.zzmb = mediationRewardedVideoAdListener;
        this.zzmb.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzlz == null || this.zzmb == null) {
            zzazw.zzfa("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzma = new InterstitialAd(this.zzlz);
        this.zzma.zzd(true);
        this.zzma.setAdUnitId(this.getAdUnitId(bundle));
        this.zzma.setRewardedVideoAdListener(this.zzmc);
        this.zzma.setAdMetadataListener(new com.google.ads.mediation.zza(this));
        this.zzma.loadAd(this.zza(this.zzlz, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzma.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzmb != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzmb;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzma = null;
        return null;
    }

    static /* synthetic */ InterstitialAd zzb(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzma;
    }

    static final class zza
    extends NativeContentAdMapper {
        private final NativeContentAd zzme;

        public zza(NativeContentAd nativeContentAd) {
            this.zzme = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzme);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzblg.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzme);
            }
        }
    }

    static final class zzd
    extends UnifiedNativeAdMapper {
        private final UnifiedNativeAd zzmi;

        public zzd(UnifiedNativeAd unifiedNativeAd) {
            this.zzmi = unifiedNativeAd;
            this.setHeadline(unifiedNativeAd.getHeadline());
            this.setImages(unifiedNativeAd.getImages());
            this.setBody(unifiedNativeAd.getBody());
            this.setIcon(unifiedNativeAd.getIcon());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setAdvertiser(unifiedNativeAd.getAdvertiser());
            this.setStarRating(unifiedNativeAd.getStarRating());
            this.setStore(unifiedNativeAd.getStore());
            this.setPrice(unifiedNativeAd.getPrice());
            this.zzn(unifiedNativeAd.zzjv());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(unifiedNativeAd.getVideoController());
        }

        @Override
        public final void trackViews(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof UnifiedNativeAdView) {
                ((UnifiedNativeAdView)view).setNativeAd(this.zzmi);
                return;
            }
            NativeAdViewHolder nativeAdViewHolder = NativeAdViewHolder.zzblg.get(view);
            if (nativeAdViewHolder != null) {
                nativeAdViewHolder.setNativeAd(this.zzmi);
            }
        }
    }

    static final class zzb
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzmf;

        public zzb(NativeAppInstallAd nativeAppInstallAd) {
            this.zzmf = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzmf);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzblg.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzmf);
            }
        }
    }

    @VisibleForTesting
    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.OnUnifiedNativeAdLoadedListener {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmg;
        @VisibleForTesting
        private final MediationNativeListener zzmj;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzmg = abstractAdViewAdapter;
            this.zzmj = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmj.onAdFailedToLoad(this.zzmg, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmj.onAdOpened(this.zzmg);
        }

        @Override
        public final void onAdClosed() {
            this.zzmj.onAdClosed(this.zzmg);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmj.onAdLeftApplication(this.zzmg);
        }

        @Override
        public final void onAdClicked() {
            this.zzmj.onAdClicked(this.zzmg);
        }

        @Override
        public final void onAdImpression() {
            this.zzmj.onAdImpression(this.zzmg);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzmj.onAdLoaded((MediationNativeAdapter)this.zzmg, new zzb(nativeAppInstallAd));
        }

        @Override
        public final void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
            this.zzmj.onAdLoaded((MediationNativeAdapter)this.zzmg, new zzd(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzmj.onAdLoaded((MediationNativeAdapter)this.zzmg, new zza(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzmj.zza(this.zzmg, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzmj.zza(this.zzmg, nativeCustomTemplateAd, string);
        }
    }

    @VisibleForTesting
    static final class zzf
    extends AdListener
    implements zzub {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmg;
        @VisibleForTesting
        private final MediationInterstitialListener zzmk;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzmg = abstractAdViewAdapter;
            this.zzmk = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmk.onAdLoaded(this.zzmg);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmk.onAdFailedToLoad(this.zzmg, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmk.onAdOpened(this.zzmg);
        }

        @Override
        public final void onAdClosed() {
            this.zzmk.onAdClosed(this.zzmg);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmk.onAdLeftApplication(this.zzmg);
        }

        @Override
        public final void onAdClicked() {
            this.zzmk.onAdClicked(this.zzmg);
        }
    }

    @VisibleForTesting
    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzub {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmg;
        @VisibleForTesting
        private final MediationBannerListener zzmh;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzmg = abstractAdViewAdapter;
            this.zzmh = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmh.onAdLoaded(this.zzmg);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmh.onAdFailedToLoad(this.zzmg, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmh.onAdOpened(this.zzmg);
        }

        @Override
        public final void onAdClosed() {
            this.zzmh.onAdClosed(this.zzmg);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmh.onAdLeftApplication(this.zzmg);
        }

        @Override
        public final void onAdClicked() {
            this.zzmh.onAdClicked(this.zzmg);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzmh.zza(this.zzmg, string, string2);
        }
    }
}

