/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzaey;
import com.google.android.gms.internal.ads.zzafa;
import com.google.android.gms.internal.ads.zzafb;
import com.google.android.gms.internal.ads.zzafc;
import com.google.android.gms.internal.ads.zzafd;
import com.google.android.gms.internal.ads.zzafe;
import com.google.android.gms.internal.ads.zzalm;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzuf;
import com.google.android.gms.internal.ads.zzuk;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzvr;
import com.google.android.gms.internal.ads.zzvs;
import com.google.android.gms.internal.ads.zzxt;

public class AdLoader {
    private final zzuk zzaca;
    private final Context zzvf;
    private final zzvr zzacb;

    AdLoader(Context context, zzvr zzvr2) {
        this(context, zzvr2, zzuk.zzcev);
    }

    private AdLoader(Context context, zzvr zzvr2, zzuk zzuk2) {
        this.zzvf = context;
        this.zzacb = zzvr2;
        this.zzaca = zzuk2;
    }

    private final void zza(zzxt zzxt2) {
        try {
            this.zzacb.zzb(zzuk.zza(this.zzvf, zzxt2));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzdq());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzxt zzxt2 = adRequest.zzdq();
        AdLoader adLoader = this;
        try {
            adLoader.zzacb.zza(zzuk.zza(adLoader.zzvf, zzxt2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzdq());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzacb.zzkh();
        }
        catch (RemoteException remoteException) {
            zzazw.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzacb.isLoading();
        }
        catch (RemoteException remoteException) {
            zzazw.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzvf;
        private final zzvs zzabz;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzvj.zzps().zzb(context, string, new zzalm()));
        }

        private Builder(Context context, zzvs zzvs2) {
            this.zzvf = context;
            this.zzabz = zzvs2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzabz.zza(new zzafb(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzabz.zza(new zzaey(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzabz.zza(new zzafe(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzabz.zza(string, new zzafd(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzafa(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzum zzum2 = new zzum(this.zzvf, adSizeArray);
                this.zzabz.zza(new zzafc(onPublisherAdViewLoadedListener), zzum2);
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzabz.zzb(new zzuf(adListener));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzabz.zza(new zzaci(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzabz.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzazw.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        @Deprecated
        @KeepForSdk
        public Builder withCorrelator(@NonNull Correlator correlator) {
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzvf, this.zzabz.zzqa());
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

