/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzxv;

class BaseAdView
extends ViewGroup {
    protected final zzxv zzacm;

    public BaseAdView(Context context, int n) {
        super(context);
        this.zzacm = new zzxv(this, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.zzacm = new zzxv(this, attributeSet, false, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.zzacm = new zzxv(this, attributeSet, false, n2);
    }

    public void destroy() {
        this.zzacm.destroy();
    }

    public AdListener getAdListener() {
        return this.zzacm.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzacm.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzacm.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzacm.zza(adRequest.zzdq());
    }

    public void pause() {
        this.zzacm.pause();
    }

    public void resume() {
        this.zzacm.resume();
    }

    public boolean isLoading() {
        return this.zzacm.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzacm.setAdListener(adListener);
        if (adListener == null) {
            this.zzacm.zza((zzub)null);
            this.zzacm.setAppEventListener(null);
            return;
        }
        if (adListener instanceof zzub) {
            this.zzacm.zza((zzub)((Object)adListener));
        }
        if (adListener instanceof AppEventListener) {
            this.zzacm.setAppEventListener((AppEventListener)((Object)adListener));
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzacm.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzacm.setAdUnitId(string);
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        return this.zzacm.getMediationAdapterClassName();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzazw.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }

    @Nullable
    public ResponseInfo getResponseInfo() {
        return this.zzacm.getResponseInfo();
    }

    public void setOnPaidEventListener(@Nullable OnPaidEventListener onPaidEventListener) {
        this.zzacm.setOnPaidEventListener(onPaidEventListener);
    }
}

