/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadd;
import com.google.android.gms.internal.ads.zzazw;
import com.google.android.gms.internal.ads.zzvj;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzadd zzblf;
    public static WeakHashMap<View, NativeAdViewHolder> zzblg = new WeakHashMap();
    private WeakReference<View> zzblh;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzazw.zzfa("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzblg.get(view) != null) {
            zzazw.zzfa("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzblg.put(view, this);
        this.zzblh = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzblf = zzvj.zzps().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zza((IObjectWrapper)nativeAd.zzjq());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zza((IObjectWrapper)unifiedNativeAd.zzjq());
    }

    private final void zza(IObjectWrapper iObjectWrapper) {
        View view = this.zzblh != null ? (View)this.zzblh.get() : null;
        if (view == null) {
            zzazw.zzfc("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzblg.containsKey(view)) {
            zzblg.put(view, this);
        }
        if (this.zzblf != null) {
            try {
                this.zzblf.zza(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzblf != null) {
            try {
                this.zzblf.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzazw.zzc("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzblh != null ? (View)this.zzblh.get() : null) != null) {
            zzblg.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzblf.zze(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzazw.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

